/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.logging.logback.deployment;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.event.BodyEvent;
import ch.qos.logback.core.joran.event.EndEvent;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.StartEvent;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.util.Loader;
import io.quarkiverse.logback.runtime.DelayedStart;
import io.quarkiverse.logback.runtime.LogbackRecorder;
import io.quarkiverse.logback.runtime.events.BodySub;
import io.quarkiverse.logback.runtime.events.EndSub;
import io.quarkiverse.logback.runtime.events.EventSubstitution;
import io.quarkiverse.logback.runtime.events.StartSub;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.resolver.update.DefaultArtifactVersion;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LogHandlerBuildItem;
import io.quarkus.deployment.builditem.RemovedResourceBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.runtime.ShutdownContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

class LoggingLogbackProcessor {
    private static final Logger log = Logger.getLogger(LoggingLogbackProcessor.class);
    private static final String FEATURE = "logging-logback";
    public static final String PROJECT_VERSION = "project.version";

    LoggingLogbackProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    RemovedResourceBuildItem removeSlf4jBinding() {
        return new RemovedResourceBuildItem((ArtifactKey)new AppArtifactKey("ch.qos.logback", "logback-classic", null, "jar"), Collections.singleton("org/slf4j/impl/StaticLoggerBinder.class"));
    }

    @BuildStep
    HotDeploymentWatchedFileBuildItem watchLogback() {
        return new HotDeploymentWatchedFileBuildItem("logback.xml");
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void init(LogbackRecorder recorder, RecorderContext context, BuildProducer<RunTimeConfigurationDefaultBuildItem> runTimeConfigurationDefaultBuildItemBuildProducer, BuildProducer<GeneratedClassBuildItem> generatedClasses, OutputTargetBuildItem outputTargetBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem, ShutdownContextBuildItem shutdownContextBuildItem) throws Exception {
        ClassCreator c;
        this.doVersionCheck();
        URL url = this.getUrl();
        if (url == null) {
            return;
        }
        context.registerSubstitution(StartEvent.class, StartSub.class, EventSubstitution.class);
        context.registerSubstitution(BodyEvent.class, BodySub.class, EventSubstitution.class);
        context.registerSubstitution(EndEvent.class, EndSub.class, EventSubstitution.class);
        final AtomicReference events = new AtomicReference();
        JoranConfigurator configurator = new JoranConfigurator(){

            public void doConfigure(List<SaxEvent> eventList) throws JoranException {
                events.set(eventList);
            }
        };
        configurator.setContext((Context)new LoggerContext());
        configurator.doConfigure(url);
        List<String> loggerPath = Arrays.asList("configuration", "logger");
        List<String> rootPath = Arrays.asList("configuration", "root");
        String rootLevel = null;
        HashMap<String, String> levels = new HashMap<String, String>();
        HashSet<String> allClasses = new HashSet<String>();
        for (SaxEvent i : (List)events.get()) {
            int n;
            String string;
            if (!(i instanceof StartEvent)) continue;
            StartEvent s2 = (StartEvent)i;
            if (Objects.equals(loggerPath, s2.elementPath.getCopyOfPartList())) {
                String string2 = s2.attributes.getValue("level");
                if (string2 != null) {
                    levels.put(s2.attributes.getValue("name"), string2);
                }
            } else if (Objects.equals(rootPath, s2.elementPath.getCopyOfPartList()) && (string = s2.attributes.getValue("level")) != null) {
                rootLevel = string;
            }
            if ((n = s2.attributes.getIndex("class")) == -1) continue;
            allClasses.add(s2.attributes.getValue(n));
        }
        boolean disableConsole = false;
        HashSet<String> delayedClasses = new HashSet<String>();
        for (String string : allClasses) {
            if (string.equals("ch.qos.logback.core.ConsoleAppender")) {
                disableConsole = true;
            }
            try {
                c = Thread.currentThread().getContextClassLoader().loadClass(string);
                if (!LifeCycle.class.isAssignableFrom((Class<?>)c)) continue;
                delayedClasses.add(string);
            }
            catch (ClassNotFoundException exception) {
                throw new RuntimeException(exception);
            }
        }
        if (disableConsole) {
            runTimeConfigurationDefaultBuildItemBuildProducer.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("quarkus.log.console.enable", "false"));
        }
        for (String string : delayedClasses) {
            c = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClasses, s -> s.substring(s.length() - "$$delayed".length())), string + "$$delayed", null, string, new String[]{DelayedStart.class.getName()});
            try {
                MethodCreator start = c.getMethodCreator("start", Void.TYPE, new Class[0]);
                start.invokeStaticMethod(MethodDescriptor.ofMethod(LogbackRecorder.class, (String)"addDelayed", Void.TYPE, (Class[])new Class[]{DelayedStart.class}), new ResultHandle[]{start.getThis()});
                start.returnValue(null);
                MethodCreator method = c.getMethodCreator("doQuarkusDelayedStart", Void.TYPE, new Class[0]);
                method.invokeSpecialMethod(MethodDescriptor.ofMethod((Object)string, (String)"start", Void.TYPE, (Object[])new Object[0]), method.getThis(), new ResultHandle[0]);
                method.returnValue(null);
            }
            finally {
                c.close();
            }
        }
        if (rootLevel != null) {
            runTimeConfigurationDefaultBuildItemBuildProducer.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("quarkus.log.level", rootLevel));
        }
        for (Map.Entry entry : levels.entrySet()) {
            runTimeConfigurationDefaultBuildItemBuildProducer.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("quarkus.log.categories.\\\"" + (String)entry.getKey() + "\\\".level", (String)entry.getValue()));
        }
        HashMap<String, String> buildProperties = new HashMap<String, String>(outputTargetBuildItem.getBuildSystemProperties().entrySet().stream().collect(Collectors.toMap(Object::toString, Object::toString)));
        buildProperties.put(PROJECT_VERSION, curateOutcomeBuildItem.getEffectiveModel().getAppArtifact().getVersion());
        recorder.init((List)events.get(), delayedClasses, (ShutdownContext)shutdownContextBuildItem, buildProperties);
    }

    private void doVersionCheck() throws IOException {
        Properties p;
        DefaultArtifactVersion compiledVersion;
        DefaultArtifactVersion coreVersion = null;
        DefaultArtifactVersion classicVersion = null;
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("quarkus-logback-version.txt");){
            compiledVersion = new DefaultArtifactVersion(new String(in.readAllBytes(), StandardCharsets.UTF_8));
        }
        in = this.getClass().getClassLoader().getResourceAsStream("META-INF/maven/ch.qos.logback/logback-core/pom.properties");
        try {
            if (in != null) {
                p = new Properties();
                p.load(in);
                coreVersion = new DefaultArtifactVersion(p.getProperty("version"));
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        in = this.getClass().getClassLoader().getResourceAsStream("META-INF/maven/ch.qos.logback/logback-classic/pom.properties");
        try {
            if (in != null) {
                p = new Properties();
                p.load(in);
                classicVersion = new DefaultArtifactVersion(p.getProperty("version"));
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        if (coreVersion != null) {
            if (coreVersion.compareTo(compiledVersion) < 0) {
                throw new RuntimeException("ch.qos.logback:logback-core version " + coreVersion + " is not compatible with quarkus-logback which requires at least " + compiledVersion + " please use the correct logback version");
            }
            if (classicVersion != null && classicVersion.compareTo(coreVersion) != 0) {
                throw new RuntimeException("logback-core(" + coreVersion + ") and logback-classic(" + classicVersion + ") versions must match");
            }
        } else {
            log.warn((Object)"Could not determine logback version on class path");
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    LogHandlerBuildItem handler(LogbackRecorder recorder) {
        return new LogHandlerBuildItem(recorder.createHandler());
    }

    private URL getUrl() {
        URL url = Loader.getResource((String)"logback-test.xml", (ClassLoader)Thread.currentThread().getContextClassLoader());
        if (url != null) {
            return url;
        }
        return Loader.getResource((String)"logback.xml", (ClassLoader)Thread.currentThread().getContextClassLoader());
    }
}

