/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.logback.runtime;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.ThrowableProxy;
import io.quarkiverse.logback.runtime.LogbackRecorder;
import java.util.Map;
import java.util.logging.Formatter;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Level;
import org.slf4j.Marker;

public class LoggingEventWrapper
implements ILoggingEvent {
    final ExtLogRecord logRecord;
    final Formatter formatter;

    public LoggingEventWrapper(ExtLogRecord logRecord, Formatter formatter) {
        this.logRecord = logRecord;
        this.formatter = formatter;
    }

    public String getThreadName() {
        return this.logRecord.getThreadName();
    }

    public ch.qos.logback.classic.Level getLevel() {
        if (this.logRecord.getLevel().intValue() >= Level.ERROR.intValue()) {
            return ch.qos.logback.classic.Level.ERROR;
        }
        if (this.logRecord.getLevel().intValue() >= Level.WARNING.intValue()) {
            return ch.qos.logback.classic.Level.WARN;
        }
        if (this.logRecord.getLevel().intValue() >= Level.INFO.intValue()) {
            return ch.qos.logback.classic.Level.INFO;
        }
        if (this.logRecord.getLevel().intValue() >= Level.DEBUG.intValue()) {
            return ch.qos.logback.classic.Level.DEBUG;
        }
        if (this.logRecord.getLevel().intValue() >= Level.TRACE.intValue()) {
            return ch.qos.logback.classic.Level.TRACE;
        }
        return ch.qos.logback.classic.Level.OFF;
    }

    public String getMessage() {
        return this.logRecord.getMessage();
    }

    public Object[] getArgumentArray() {
        return this.logRecord.getParameters();
    }

    public String getFormattedMessage() {
        return this.logRecord.getFormattedMessage();
    }

    public String getLoggerName() {
        return this.logRecord.getLoggerName();
    }

    public LoggerContextVO getLoggerContextVO() {
        return LogbackRecorder.defaultLoggerContext.getLoggerContextRemoteView();
    }

    public IThrowableProxy getThrowableProxy() {
        if (this.logRecord.getThrown() != null) {
            return new ThrowableProxy(this.logRecord.getThrown());
        }
        return null;
    }

    public StackTraceElement[] getCallerData() {
        return null;
    }

    public boolean hasCallerData() {
        return false;
    }

    public Marker getMarker() {
        return (Marker)this.logRecord.getMarker();
    }

    public Map<String, String> getMDCPropertyMap() {
        return this.logRecord.getMdcCopy();
    }

    public Map<String, String> getMdc() {
        return this.getMDCPropertyMap();
    }

    public long getTimeStamp() {
        return this.logRecord.getMillis();
    }

    public void prepareForDeferredProcessing() {
    }
}

