/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.logback.runtime;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.event.BodyEvent;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.StartEvent;
import ch.qos.logback.core.status.StatusUtil;
import ch.qos.logback.core.util.StatusPrinter;
import io.quarkiverse.logback.runtime.DelayedStart;
import io.quarkiverse.logback.runtime.LoggingEventWrapper;
import io.quarkiverse.logback.runtime.events.BodySub;
import io.quarkiverse.logback.runtime.events.EventSubstitution;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.common.expression.Expression;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigProviderResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Handler;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;
import org.slf4j.helpers.Util;
import org.xml.sax.helpers.AttributesImpl;

@Recorder
public class LogbackRecorder {
    public static final String DELAYED = "$$delayed";
    static volatile LoggerContext defaultLoggerContext;
    public static final List<DelayedStart> DELAYED_START_HANDLERS;
    private static volatile boolean started;

    public static void addDelayed(DelayedStart delayedStart) {
        if (started) {
            delayedStart.doQuarkusDelayedStart();
        } else {
            DELAYED_START_HANDLERS.add(delayedStart);
        }
    }

    public void init(List<SaxEvent> originalEvents, Set<String> delayedStartClasses, ShutdownContext context, Map<String, String> buildSystemProps) {
        EventSubstitution substitution = new EventSubstitution();
        if (defaultLoggerContext == null) {
            SmallRyeConfig config = (SmallRyeConfig)SmallRyeConfigProviderResolver.instance().getConfig();
            ArrayList<SaxEvent> configEvents = new ArrayList<SaxEvent>();
            for (SaxEvent i : originalEvents) {
                if (i instanceof StartEvent) {
                    String val;
                    AttributesImpl impl = (AttributesImpl)((StartEvent)i).attributes;
                    int index = impl.getIndex("class");
                    if (index > -1 && delayedStartClasses.contains(val = impl.getValue(index))) {
                        impl.setValue(index, val + DELAYED);
                    }
                    for (int j = 1; j <= impl.getLength(); ++j) {
                        String val2 = impl.getValue(index);
                        if (val2 == null || !val2.contains("${")) continue;
                        String expanded = this.doExpand(config, val2, buildSystemProps);
                        impl.setValue(j, expanded);
                    }
                    configEvents.add(i);
                    continue;
                }
                if (i instanceof BodyEvent) {
                    String val = ((BodyEvent)i).getText();
                    if (val.contains("${")) {
                        String expanded = this.doExpand(config, val, buildSystemProps);
                        configEvents.add(substitution.deserialize(new BodySub(i.getNamespaceURI(), i.getLocalName(), i.getQName(), i.getLocator(), expanded)));
                        continue;
                    }
                    configEvents.add(i);
                    continue;
                }
                configEvents.add(i);
            }
            defaultLoggerContext = new LoggerContext();
            try {
                JoranConfigurator configurator = new JoranConfigurator();
                configurator.setContext((Context)defaultLoggerContext);
                configurator.doConfigure(configEvents);
                if (!StatusUtil.contextHasStatusListener((Context)defaultLoggerContext)) {
                    StatusPrinter.printInCaseOfErrorsOrWarnings((Context)defaultLoggerContext);
                }
            }
            catch (Exception t) {
                Util.report((String)("Failed to instantiate [" + LoggerContext.class.getName() + "]"), (Throwable)t);
            }
            context.addLastShutdownTask(new Runnable(){

                @Override
                public void run() {
                    defaultLoggerContext.stop();
                    defaultLoggerContext = null;
                    started = false;
                }
            });
        }
    }

    private String doExpand(SmallRyeConfig config, String val, Map<String, String> buildSystemProps) {
        Expression expression = Expression.compile((String)val, (Expression.Flag[])new Expression.Flag[0]);
        String expanded = expression.evaluate((resolveContext, stringBuilder) -> {
            ConfigValue resolve = config.getConfigValue(resolveContext.getKey());
            if (resolve.getValue() != null) {
                stringBuilder.append(resolve.getValue());
            } else if (buildSystemProps.containsKey(resolveContext.getKey())) {
                stringBuilder.append((String)buildSystemProps.get(resolveContext.getKey()));
            } else if (resolveContext.hasDefault()) {
                resolveContext.expandDefault();
            } else {
                stringBuilder.append("${" + resolveContext.getKey() + "}");
            }
        });
        return expanded;
    }

    public RuntimeValue<Optional<Handler>> createHandler() {
        started = true;
        for (DelayedStart i : DELAYED_START_HANDLERS) {
            i.doQuarkusDelayedStart();
        }
        DELAYED_START_HANDLERS.clear();
        return new RuntimeValue(Optional.of(new ExtHandler(){

            public final void doPublish(ExtLogRecord record) {
                if (defaultLoggerContext == null) {
                    return;
                }
                Logger logger = defaultLoggerContext.getLogger(record.getLoggerName());
                logger.callAppenders((ILoggingEvent)new LoggingEventWrapper(record, this.getFormatter()));
            }

            public void flush() {
            }

            public void close() throws SecurityException {
            }
        }));
    }

    static {
        DELAYED_START_HANDLERS = new ArrayList<DelayedStart>();
    }
}

