/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.logging.splunk;

import com.splunk.logging.HttpEventCollectorErrorHandler;
import com.splunk.logging.HttpEventCollectorEventInfo;
import io.quarkus.bootstrap.logging.InitialConfigurator;
import io.quarkus.bootstrap.logging.QuarkusDelayedHandler;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.logmanager.handlers.ConsoleHandler;

class SplunkErrorCallback
implements HttpEventCollectorErrorHandler.ErrorCallback {
    Boolean consoleEnabled;
    PrintStream stdout;
    PrintStream stderr;

    SplunkErrorCallback() {
        this(System.out, System.err);
    }

    SplunkErrorCallback(PrintStream stdout, PrintStream stderr) {
        this.stdout = stdout;
        this.stderr = stderr;
    }

    public void error(List<HttpEventCollectorEventInfo> list, Exception e) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.append("Error while sending events to Splunk HEC: ");
        stringWriter.append(e.getMessage()).append(System.lineSeparator());
        e.printStackTrace(new PrintWriter(stringWriter));
        this.stderr.println(stringWriter.toString());
        if (!this.isConsoleHandlerEnabled()) {
            for (HttpEventCollectorEventInfo logEvent : list) {
                this.stdout.println(logEvent.getMessage());
            }
        }
    }

    private boolean isConsoleHandlerEnabled() {
        if (this.consoleEnabled == null) {
            QuarkusDelayedHandler delayedHandler = InitialConfigurator.DELAYED_HANDLER;
            Handler consoleHandler = Arrays.stream(delayedHandler.getHandlers()).filter(h -> h instanceof ConsoleHandler).findFirst().orElse(null);
            this.consoleEnabled = consoleHandler != null && !consoleHandler.getLevel().equals(Level.OFF);
        }
        return this.consoleEnabled;
    }
}

