/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.logging.splunk;

import com.splunk.logging.HttpEventCollectorMiddleware;
import com.splunk.logging.HttpEventCollectorResendMiddleware;
import com.splunk.logging.HttpEventCollectorSender;
import java.util.Locale;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;

public class SplunkLogHandler
extends ExtHandler {
    private final HttpEventCollectorSender sender;
    private final boolean includeException;
    private final boolean includeLoggerName;
    private final boolean includeThreadName;

    public SplunkLogHandler(HttpEventCollectorSender sender, boolean includeException, boolean includeLoggerName, boolean includeThreadName, boolean disableCertificateValidation, long retriesOnError) {
        this.sender = sender;
        this.includeException = includeException;
        this.includeLoggerName = includeLoggerName;
        this.includeThreadName = includeThreadName;
        if (disableCertificateValidation) {
            this.sender.disableCertificateValidation();
        }
        if (retriesOnError > 0L) {
            this.sender.addMiddleware((HttpEventCollectorMiddleware.HttpSenderMiddleware)new HttpEventCollectorResendMiddleware(retriesOnError));
        }
    }

    public void doPublish(ExtLogRecord record) {
        String formatted = this.formatMessage(record);
        if (formatted.length() == 0) {
            return;
        }
        this.sender.send(record.getMillis(), record.getLevel().toString(), formatted, this.includeLoggerName ? record.getLoggerName() : null, this.includeThreadName ? String.format(Locale.US, "%d", record.getThreadID()) : null, record.getMdcCopy(), !this.includeException || record.getThrown() == null ? null : record.getThrown().getMessage(), null);
    }

    public void flush() {
        this.sender.flush();
    }

    public void close() throws SecurityException {
        this.sender.flush(true);
        this.sender.cancel();
    }

    private String formatMessage(ExtLogRecord record) {
        String formatted = "";
        Formatter formatter = this.getFormatter();
        try {
            formatted = formatter.format((LogRecord)record);
        }
        catch (Exception ex) {
            this.reportError("Formatting error", ex, 5);
        }
        return formatted;
    }
}

