/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.logging.splunk;

import com.splunk.logging.HttpEventCollectorErrorHandler;
import com.splunk.logging.HttpEventCollectorSender;
import io.quarkiverse.logging.splunk.SplunkConfig;
import io.quarkiverse.logging.splunk.SplunkErrorCallback;
import io.quarkiverse.logging.splunk.SplunkLogHandler;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import org.jboss.logmanager.formatters.PatternFormatter;

@Recorder
public class SplunkLogHandlerRecorder {
    public RuntimeValue<Optional<Handler>> initializeHandler(SplunkConfig config) {
        if (!config.enabled) {
            return new RuntimeValue(Optional.empty());
        }
        if (!config.token.isPresent()) {
            throw new IllegalArgumentException("The property quarkus.log.handler.splunk.token is mandatory");
        }
        HttpEventCollectorSender sender = SplunkLogHandlerRecorder.createSender(config);
        SplunkLogHandler splunkLogHandler = this.createSplunkLogHandler(sender, config);
        splunkLogHandler.setLevel(config.level);
        splunkLogHandler.setFormatter((Formatter)new PatternFormatter(config.format));
        return new RuntimeValue(Optional.of(splunkLogHandler));
    }

    static HttpEventCollectorSender createSender(SplunkConfig config) {
        HttpEventCollectorErrorHandler.onError((HttpEventCollectorErrorHandler.ErrorCallback)new SplunkErrorCallback());
        String type = "";
        return new HttpEventCollectorSender(config.url, config.token.get(), config.channel.orElse(""), type, config.batchInterval.getSeconds(), config.batchSizeCount, config.batchSizeBytes, config.sendMode.name().toLowerCase(), SplunkLogHandlerRecorder.buildMetadata(config), null);
    }

    static Map<String, String> buildMetadata(SplunkConfig config) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        config.metadataIndex.ifPresent(s -> metadata.put("index", (String)s));
        try {
            String hostName = InetAddress.getLocalHost().getHostName();
            metadata.put("host", config.metadataHost.orElse(hostName));
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        config.metadataSource.ifPresent(s -> metadata.put("source", (String)s));
        metadata.put("sourcetype", config.metadataSourceType);
        return metadata;
    }

    private SplunkLogHandler createSplunkLogHandler(HttpEventCollectorSender sender, SplunkConfig config) {
        return new SplunkLogHandler(sender, config.includeException, config.includeLoggerName, config.includeThreadName, config.disableCertificateValidation, config.maxRetries);
    }
}

