/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.loggingjson.deployment;

import io.quarkiverse.loggingjson.Config;
import io.quarkiverse.loggingjson.LoggingJsonRecorder;
import io.quarkiverse.loggingjson.deployment.LoggingJsonDotNames;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LogConsoleFormatBuildItem;
import java.util.Collection;
import org.jboss.jandex.ClassInfo;

class LoggingJsonProcessor {
    private static final String FEATURE = "logging-json";

    LoggingJsonProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    LogConsoleFormatBuildItem setUpFormatter(Capabilities capabilities, LoggingJsonRecorder recorder, Config config) {
        boolean useJackson;
        if (capabilities.isPresent("io.quarkus.jackson")) {
            useJackson = true;
        } else if (capabilities.isPresent("io.quarkus.jsonb")) {
            useJackson = false;
        } else {
            throw new RuntimeException("Missing json implementation to use for logging-json. Supported: [quarkus-jackson, quarkus-jsonb]");
        }
        return new LogConsoleFormatBuildItem(recorder.initializeJsonLogging(config, useJackson));
    }

    @BuildStep
    void discoverJsonProviders(BuildProducer<AdditionalBeanBuildItem> beans, CombinedIndexBuildItem combinedIndexBuildItem) {
        Collection jsonProviders = combinedIndexBuildItem.getIndex().getAllKnownImplementors(LoggingJsonDotNames.JSON_PROVIDER);
        for (ClassInfo provider : jsonProviders) {
            beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf((String)provider.name().toString()));
        }
    }
}

