/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.loggingjson;

import io.quarkiverse.loggingjson.Config;
import io.quarkiverse.loggingjson.JsonFactory;
import io.quarkiverse.loggingjson.JsonGenerator;
import io.quarkiverse.loggingjson.JsonProvider;
import io.quarkiverse.loggingjson.StringBuilderWriter;
import java.util.List;
import org.jboss.logmanager.ExtFormatter;
import org.jboss.logmanager.ExtLogRecord;

public class JsonFormatter
extends ExtFormatter {
    private final StringBuilderWriter writer = new StringBuilderWriter();
    private final List<JsonProvider> providers;
    private final JsonFactory jsonFactory;
    private String recordDelimiter;

    public JsonFormatter(List<JsonProvider> providers, JsonFactory jsonFactory, Config config) {
        this.providers = providers;
        this.jsonFactory = jsonFactory;
        this.recordDelimiter = config.recordDelimiter;
    }

    public String format(ExtLogRecord record) {
        try {
            try (Object generator = this.jsonFactory.createGenerator(this.writer);){
                generator.writeStartObject();
                for (JsonProvider provider : this.providers) {
                    provider.writeTo((JsonGenerator)generator, record);
                }
                generator.writeEndObject();
                generator.flush();
                if (this.recordDelimiter != null) {
                    this.writer.write(this.recordDelimiter);
                }
            }
            generator = this.writer.toString();
            return generator;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.writer.clear();
        }
    }
}

