/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.loggingjson.jsonb;

import io.quarkiverse.loggingjson.JsonGenerator;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.eclipse.yasson.YassonJsonb;

public class JsonbJsonGenerator
implements JsonGenerator {
    private final javax.json.stream.JsonGenerator generator;
    private final YassonJsonb jsonb;

    public JsonbJsonGenerator(javax.json.stream.JsonGenerator generator, YassonJsonb jsonb) {
        this.generator = generator;
        this.jsonb = jsonb;
    }

    @Override
    public void writeStartObject() {
        this.generator.writeStartObject();
    }

    @Override
    public void writeEndObject() {
        this.generator.writeEnd();
    }

    @Override
    public void flush() {
        this.generator.flush();
    }

    @Override
    public void close() {
        this.generator.close();
    }

    @Override
    public void writeFieldName(String name) {
        this.generator.writeKey(name);
    }

    @Override
    public void writeObject(Object pojo) {
        this.customWriteObject(null, pojo);
    }

    @Override
    public void writeObjectFieldStart(String fieldName) {
        this.generator.writeStartObject(fieldName);
    }

    @Override
    public void writeObjectField(String fieldName, Object pojo) {
        this.customWriteObject(fieldName, pojo);
    }

    @Override
    public void writeArrayFieldStart(String fieldName) {
        this.generator.writeStartArray(fieldName);
    }

    @Override
    public void writeEndArray() {
        this.generator.writeEnd();
    }

    @Override
    public void writeString(String text) {
        this.generator.write(text);
    }

    @Override
    public void writeStringField(String fieldName, String value) {
        this.generator.write(fieldName, value);
    }

    @Override
    public void writeNumberField(String fieldName, short value) throws IOException {
        this.generator.write(fieldName, (int)value);
    }

    @Override
    public void writeNumberField(String fieldName, int value) throws IOException {
        this.generator.write(fieldName, value);
    }

    @Override
    public void writeNumberField(String fieldName, long value) throws IOException {
        this.generator.write(fieldName, value);
    }

    @Override
    public void writeNumberField(String fieldName, BigInteger value) throws IOException {
        this.generator.write(fieldName, value);
    }

    @Override
    public void writeNumberField(String fieldName, float value) throws IOException {
        this.generator.write(fieldName, (double)value);
    }

    @Override
    public void writeNumberField(String fieldName, double value) throws IOException {
        this.generator.write(fieldName, value);
    }

    @Override
    public void writeNumberField(String fieldName, BigDecimal value) throws IOException {
        this.generator.write(fieldName, value);
    }

    private void customWriteObject(String key, Object obj) {
        if (obj == null) {
            if (key == null) {
                this.generator.writeNull();
            } else {
                this.generator.writeNull(key);
            }
        } else if (obj instanceof Boolean) {
            Boolean value = (Boolean)obj;
            if (key == null) {
                this.generator.write(value.booleanValue());
            } else {
                this.generator.write(key, value.booleanValue());
            }
        } else if (obj instanceof Short) {
            Short value = (Short)obj;
            if (key == null) {
                this.generator.write((int)value.shortValue());
            } else {
                this.generator.write(key, (int)value.shortValue());
            }
        } else if (obj instanceof Integer) {
            Integer value = (Integer)obj;
            if (key == null) {
                this.generator.write(value.intValue());
            } else {
                this.generator.write(key, value.intValue());
            }
        } else if (obj instanceof Long) {
            Long value = (Long)obj;
            if (key == null) {
                this.generator.write(value.longValue());
            } else {
                this.generator.write(key, value.longValue());
            }
        } else if (obj instanceof Double) {
            Double value = (Double)obj;
            if (key == null) {
                this.generator.write(value.doubleValue());
            } else {
                this.generator.write(key, value.doubleValue());
            }
        } else if (obj instanceof BigInteger) {
            BigInteger value = (BigInteger)obj;
            if (key == null) {
                this.generator.write(value);
            } else {
                this.generator.write(key, value);
            }
        } else if (obj instanceof BigDecimal) {
            BigDecimal value = (BigDecimal)obj;
            if (key == null) {
                this.generator.write(value);
            } else {
                this.generator.write(key, value);
            }
        } else if (obj instanceof String) {
            String value = (String)obj;
            if (key == null) {
                this.generator.write(value);
            } else {
                this.generator.write(key, value);
            }
        } else if (obj instanceof JsonValue) {
            JsonValue value = (JsonValue)obj;
            if (key == null) {
                this.generator.write(value);
            } else {
                this.generator.write(key, value);
            }
        } else if (obj.getClass().isArray()) {
            Object[] value = (Object[])obj;
            if (key == null) {
                this.generator.writeStartArray();
            } else {
                this.generator.writeStartArray(key);
            }
            for (Object o : value) {
                this.customWriteObject(null, o);
            }
            this.generator.writeEnd();
        } else if (obj instanceof List) {
            List value = (List)obj;
            if (key == null) {
                this.generator.writeStartArray();
            } else {
                this.generator.writeStartArray(key);
            }
            for (Object o : value) {
                this.customWriteObject(null, o);
            }
            this.generator.writeEnd();
        } else if (key == null) {
            JsonStructure jsonStructure = this.jsonb.toJsonStructure(obj);
            this.generator.write(key, (JsonValue)jsonStructure);
        } else {
            JsonStructure jsonStructure = this.jsonb.toJsonStructure(obj);
            this.generator.writeKey(key);
            if (jsonStructure.equals(JsonValue.EMPTY_JSON_OBJECT)) {
                this.generator.writeStartObject();
                this.generator.writeEnd();
            } else {
                this.generator.write((JsonValue)jsonStructure);
            }
        }
    }
}

