/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.loggingjson.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.quarkiverse.loggingjson.JsonFactory;
import io.quarkiverse.loggingjson.JsonGenerator;
import io.quarkiverse.loggingjson.StringBuilderWriter;
import io.quarkiverse.loggingjson.jackson.JacksonJsonGenerator;
import java.io.IOException;
import java.io.Writer;
import java.util.ServiceConfigurationError;

public class JacksonJsonFactory
implements JsonFactory {
    private final com.fasterxml.jackson.core.JsonFactory jsonFactory = this.createJsonFactory();

    private com.fasterxml.jackson.core.JsonFactory createJsonFactory() {
        ObjectMapper objectMapper = new ObjectMapper().disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        try {
            objectMapper.findAndRegisterModules();
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            System.err.println("Error occurred while dynamically loading jackson modules");
            serviceConfigurationError.printStackTrace();
        }
        return objectMapper.getFactory().disable(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM);
    }

    @Override
    public JsonGenerator createGenerator(StringBuilderWriter writer) throws IOException {
        return new JacksonJsonGenerator(this.jsonFactory.createGenerator((Writer)writer));
    }
}

