/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.loggingmanager.deployment;

import io.quarkus.vertx.http.runtime.logstream.LogController;
import io.smallrye.openapi.api.models.media.SchemaImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;

public class LoggingManagerOpenAPIFilter
implements OASFilter {
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String FORM_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final String REF_LOGGER_NAME = "#/components/schemas/LoggerName";
    private static final String REF_LOGGER_LEVEL = "#/components/schemas/LoggerLevel";
    private static final String REF_LIST_LOGGER_INFO = "#/components/schemas/ListLoggerInfo";
    private static final String REF_LIST_STRING = "#/components/schemas/ListString";
    private final String basePath;
    private final String tag;

    public LoggingManagerOpenAPIFilter(String basePath, String tag) {
        this.basePath = basePath;
        this.tag = tag;
    }

    public void filterOpenAPI(OpenAPI openAPI) {
        if (openAPI.getComponents() == null) {
            openAPI.setComponents(OASFactory.createComponents());
        }
        openAPI.getComponents().addSchema("LoggerName", this.createLoggerName());
        openAPI.getComponents().addSchema("LoggerLevel", this.createLoggerLevel());
        openAPI.getComponents().addSchema("ListLoggerInfo", this.createListLoggerInfo());
        openAPI.getComponents().addSchema("LoggerInfo", this.createLoggerInfo());
        openAPI.getComponents().addSchema("ListString", this.createListString());
        if (openAPI.getPaths() == null) {
            openAPI.setPaths(OASFactory.createPaths());
        }
        Paths paths = openAPI.getPaths();
        paths.addPathItem(this.basePath, this.createLoggersPathItem());
        paths.addPathItem(this.basePath + "/levels", this.createLevelsPathItem());
    }

    private PathItem createLevelsPathItem() {
        PathItem pathItem = OASFactory.createPathItem();
        pathItem.setDescription("All available levels ");
        pathItem.setSummary("Return all levels that is available");
        pathItem.setGET(this.createLevelsOperation());
        return pathItem;
    }

    private Operation createLevelsOperation() {
        Operation operation = OASFactory.createOperation();
        operation.setDescription("This returns all possible log levels");
        operation.setOperationId("logging_manager_levels");
        operation.setTags(Collections.singletonList(this.tag));
        operation.setSummary("Get all available levels");
        operation.setResponses(this.createLevelsAPIResponses());
        return operation;
    }

    private APIResponses createLevelsAPIResponses() {
        APIResponses responses = OASFactory.createAPIResponses();
        responses.addAPIResponse("200", this.createLevelsAPIResponse());
        return responses;
    }

    private APIResponse createLevelsAPIResponse() {
        APIResponse response = OASFactory.createAPIResponse();
        response.setContent(this.createLevelsContent());
        return response;
    }

    private Content createLevelsContent() {
        Content content = OASFactory.createContent();
        content.addMediaType(JSON_CONTENT_TYPE, this.createLevelsMediaType());
        return content;
    }

    private MediaType createLevelsMediaType() {
        MediaType mediaType = OASFactory.createMediaType();
        mediaType.setSchema((Schema)OASFactory.createSchema().ref(REF_LIST_STRING));
        return mediaType;
    }

    private PathItem createLoggersPathItem() {
        PathItem pathItem = OASFactory.createPathItem();
        pathItem.setDescription("Logging Manager Loggers");
        pathItem.setSummary("Return info on all loggers, or a specific logger");
        pathItem.setGET(this.createLoggersOperation());
        pathItem.setPOST(this.createLoggerPostOperation());
        return pathItem;
    }

    private Operation createLoggerPostOperation() {
        Operation operation = OASFactory.createOperation();
        operation.setDescription("Update a log level for a certain logger");
        operation.setOperationId("logging_manager_update");
        operation.setTags(Collections.singletonList(this.tag));
        operation.setSummary("Update log level");
        operation.setResponses(this.createLoggerPostAPIResponses());
        operation.setRequestBody(this.createLoggersPostRequestBody());
        return operation;
    }

    private RequestBody createLoggersPostRequestBody() {
        RequestBody requestBody = OASFactory.createRequestBody();
        requestBody.setContent(this.createRequestBodyContent());
        return requestBody;
    }

    private Content createRequestBodyContent() {
        Content content = OASFactory.createContent();
        content.addMediaType(FORM_CONTENT_TYPE, this.createRequestBodyMediaType());
        return content;
    }

    private MediaType createRequestBodyMediaType() {
        MediaType mediaType = OASFactory.createMediaType();
        Schema schema = OASFactory.createSchema();
        schema.setType(Schema.SchemaType.OBJECT);
        HashMap<String, Schema> properties = new HashMap<String, Schema>();
        properties.put("loggerName", (Schema)OASFactory.createSchema().ref(REF_LOGGER_NAME));
        properties.put("loggerLevel", (Schema)OASFactory.createSchema().ref(REF_LOGGER_LEVEL));
        schema.setProperties(properties);
        mediaType.setSchema(schema);
        return mediaType;
    }

    private APIResponses createLoggerPostAPIResponses() {
        APIResponses responses = OASFactory.createAPIResponses();
        APIResponse apiResponse = OASFactory.createAPIResponse();
        apiResponse.setDescription("Created");
        responses.addAPIResponse("201", apiResponse);
        return responses;
    }

    private Operation createLoggersOperation() {
        Operation operation = OASFactory.createOperation();
        operation.setDescription("Get information on all loggers or a specific logger.");
        operation.setOperationId("logging_manager_get_all");
        operation.setTags(Collections.singletonList(this.tag));
        operation.setSummary("Information on Logger(s)");
        operation.setResponses(this.createLoggersAPIResponses());
        operation.addParameter(this.createLoggersParameter());
        return operation;
    }

    private APIResponses createLoggersAPIResponses() {
        APIResponses responses = OASFactory.createAPIResponses();
        responses.addAPIResponse("200", this.createLoggersAPIResponse());
        APIResponse notFound = OASFactory.createAPIResponse();
        notFound.setDescription("Not Found");
        responses.addAPIResponse("404", notFound);
        return responses;
    }

    private APIResponse createLoggersAPIResponse() {
        APIResponse response = OASFactory.createAPIResponse();
        response.setContent(this.createLoggersContent());
        return response;
    }

    private Content createLoggersContent() {
        Content content = OASFactory.createContent();
        content.addMediaType(JSON_CONTENT_TYPE, this.createLoggersMediaType());
        return content;
    }

    private MediaType createLoggersMediaType() {
        MediaType mediaType = OASFactory.createMediaType();
        mediaType.setSchema((Schema)OASFactory.createSchema().ref(REF_LIST_LOGGER_INFO));
        return mediaType;
    }

    private Parameter createLoggersParameter() {
        Parameter p = OASFactory.createParameter();
        p.setName("loggerName");
        p.setIn(Parameter.In.QUERY);
        p.setSchema(OASFactory.createSchema().type(Schema.SchemaType.STRING));
        return p;
    }

    private Schema createLoggerName() {
        SchemaImpl schema = new SchemaImpl("LoggerName");
        schema.setType(Schema.SchemaType.STRING);
        schema.setDescription("The logger name");
        return schema;
    }

    private Schema createLoggerLevel() {
        SchemaImpl schema = new SchemaImpl("LoggerLevel");
        schema.setType(Schema.SchemaType.STRING);
        List loggerLevels = LogController.LEVELS;
        for (String l : loggerLevels) {
            schema.addEnumeration((Object)l);
        }
        return schema;
    }

    private Schema createLoggerInfo() {
        SchemaImpl schema = new SchemaImpl("LoggerInfo");
        schema.setType(Schema.SchemaType.OBJECT);
        schema.setProperties(this.createLoggerInfoProperties());
        return schema;
    }

    private Map<String, Schema> createLoggerInfoProperties() {
        HashMap<String, Schema> map = new HashMap<String, Schema>();
        map.put("configuredLevel", this.createStringSchema("configuredLevel"));
        map.put("effectiveLevel", this.createStringSchema("effectiveLevel"));
        map.put("name", this.createStringSchema("name"));
        return map;
    }

    private Schema createStringSchema(String name) {
        SchemaImpl schema = new SchemaImpl(name);
        schema.setType(Schema.SchemaType.STRING);
        return schema;
    }

    private Schema createListString() {
        SchemaImpl schema = new SchemaImpl("ListString");
        schema.setType(Schema.SchemaType.ARRAY);
        schema.setItems(new SchemaImpl().type(Schema.SchemaType.STRING));
        return schema;
    }

    private Schema createListLoggerInfo() {
        SchemaImpl schema = new SchemaImpl("ListLoggerInfo");
        schema.setType(Schema.SchemaType.ARRAY);
        schema.setItems((Schema)new SchemaImpl().ref(REF_LIST_LOGGER_INFO));
        return schema;
    }
}

