/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.loggingmanager.deployment;

import io.quarkiverse.loggingmanager.LoggerManagerRecorder;
import io.quarkiverse.loggingmanager.LoggingManagerRuntimeConfig;
import io.quarkiverse.loggingmanager.deployment.LoggingManagerBuildItem;
import io.quarkiverse.loggingmanager.deployment.LoggingManagerConfig;
import io.quarkiverse.loggingmanager.deployment.LoggingManagerOpenAPIFilter;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LogHandlerBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.deployment.logging.LogStreamBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.util.IoUtil;
import io.quarkus.deployment.util.WebJarUtil;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.smallrye.openapi.deployment.spi.AddToOpenAPIDefinitionBuildItem;
import io.quarkus.vertx.http.deployment.BodyHandlerBuildItem;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.runtime.logstream.JsonFormatter;
import io.quarkus.vertx.http.runtime.logstream.LogStreamRecorder;
import io.quarkus.vertx.http.runtime.logstream.LogStreamWebSocket;
import io.quarkus.vertx.http.runtime.logstream.WebSocketLogHandler;
import io.vertx.core.Handler;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.OASFilter;

class LoggingManagerProcessor {
    private static final String FEATURE = "logging-manager";
    private static final String UI_WEBJAR_GROUP_ID = "io.quarkiverse.loggingmanager";
    private static final String UI_WEBJAR_ARTIFACT_ID = "quarkus-logging-manager";
    private static final String UI_FINAL_DESTINATION = "META-INF/logging-manager-files";
    private static final String STATIC_RESOURCE_FOLDER = "dev-static/";
    private static final String INDEX_HTML = "index.html";
    private static final String LOGO_SVG = "quarkiverse_icon_reverse.svg";
    private final Config config = ConfigProvider.getConfig();

    LoggingManagerProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void includeRestEndpoints(BuildProducer<RouteBuildItem> routeProducer, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, LoggingManagerConfig loggingManagerConfig, BodyHandlerBuildItem bodyHandlerBuildItem, LoggerManagerRecorder recorder, LaunchModeBuildItem launchMode, LoggingManagerRuntimeConfig runtimeConfig) {
        if (LoggingManagerProcessor.shouldInclude(launchMode, loggingManagerConfig)) {
            Handler loggerHandler = recorder.loggerHandler();
            Handler levelHandler = recorder.levelHandler();
            routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().routeFunction(loggingManagerConfig.basePath, recorder.routeConsumer(bodyHandlerBuildItem.getHandler(), runtimeConfig)).displayOnNotFoundPage("All available loggers").handler(loggerHandler).build());
            routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().nestedRoute(loggingManagerConfig.basePath, "levels").displayOnNotFoundPage("All available log levels").handler(levelHandler).build());
        }
    }

    @BuildStep(onlyIf={OpenAPIIncluded.class})
    public void includeInOpenAPIEndpoint(BuildProducer<AddToOpenAPIDefinitionBuildItem> openAPIProducer, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, Capabilities capabilities, LaunchModeBuildItem launchMode, LoggingManagerConfig loggingManagerConfig) {
        if (capabilities.isPresent("io.quarkus.smallrye.openapi") && LoggingManagerProcessor.shouldInclude(launchMode, loggingManagerConfig)) {
            LoggingManagerOpenAPIFilter filter = new LoggingManagerOpenAPIFilter(nonApplicationRootPathBuildItem.resolvePath(loggingManagerConfig.basePath), loggingManagerConfig.openapiTag);
            openAPIProducer.produce((BuildItem)new AddToOpenAPIDefinitionBuildItem((OASFilter)filter));
        }
    }

    @BuildStep
    void includeUiAndWebsocket(BuildProducer<AdditionalBeanBuildItem> annotatedProducer, BuildProducer<RouteBuildItem> routeProducer, BuildProducer<LoggingManagerBuildItem> loggingManagerBuildProducer, BuildProducer<LogStreamBuildItem> logStreamBuildProducer, HttpRootPathBuildItem httpRootPathBuildItem, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, BuildProducer<GeneratedResourceBuildItem> generatedResourceProducer, BuildProducer<NativeImageResourceBuildItem> nativeImageResourceProducer, CurateOutcomeBuildItem curateOutcomeBuildItem, LaunchModeBuildItem launchMode, LoggingManagerConfig loggingManagerConfig) throws Exception {
        if ("/".equals(loggingManagerConfig.ui.rootPath)) {
            throw new ConfigurationError("quarkus.logging-manager.ui.root-path was set to \"/\", this is not allowed as it blocks the application from serving anything else.");
        }
        ResolvedDependency resolvedDependency = WebJarUtil.getAppArtifact((CurateOutcomeBuildItem)curateOutcomeBuildItem, (String)UI_WEBJAR_GROUP_ID, (String)UI_WEBJAR_ARTIFACT_ID);
        AppArtifact userApplication = curateOutcomeBuildItem.getEffectiveModel().getAppArtifact();
        String uiPath = nonApplicationRootPathBuildItem.resolvePath(loggingManagerConfig.ui.rootPath);
        if (launchMode.getLaunchMode().isDevOrTest()) {
            Path tempPath = WebJarUtil.createResourcesDirectory((ResolvedDependency)userApplication, (ResolvedDependency)resolvedDependency);
            Path indexHtml = Paths.get(tempPath.toString(), INDEX_HTML);
            if (!Files.exists(indexHtml, new LinkOption[0])) {
                Files.createFile(indexHtml, new FileAttribute[0]);
            }
            String indexHtmlContent = this.getIndexHtmlContents(nonApplicationRootPathBuildItem.getNonApplicationRootPath(), "/dev/logstream");
            Files.write(indexHtml, indexHtmlContent.getBytes(), new OpenOption[0]);
            Path logoSvg = Paths.get(tempPath.toString(), LOGO_SVG);
            if (!Files.exists(logoSvg, new LinkOption[0])) {
                Files.createFile(logoSvg, new FileAttribute[0]);
            }
            byte[] logo = this.getLogo();
            Files.write(logoSvg, logo, new OpenOption[0]);
            loggingManagerBuildProducer.produce((BuildItem)new LoggingManagerBuildItem(tempPath.toAbsolutePath().toString(), uiPath));
        } else if (loggingManagerConfig.ui.alwaysInclude) {
            logStreamBuildProducer.produce((BuildItem)new LogStreamBuildItem());
            annotatedProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(LogStreamWebSocket.class));
            annotatedProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(WebSocketLogHandler.class));
            String indexHtmlContent = this.getIndexHtmlContents(nonApplicationRootPathBuildItem.getNonApplicationRootPath(), "/" + loggingManagerConfig.basePath + "/logstream");
            String pathToBeReplaced = nonApplicationRootPathBuildItem.resolvePath("dev/resources");
            indexHtmlContent = indexHtmlContent.replaceAll(pathToBeReplaced + "/", "");
            String indexHtmlFileName = "META-INF/logging-manager-files/index.html";
            generatedResourceProducer.produce((BuildItem)new GeneratedResourceBuildItem(indexHtmlFileName, indexHtmlContent.getBytes()));
            nativeImageResourceProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{indexHtmlFileName}));
            byte[] logo = this.getLogo();
            String logoFileName = "META-INF/logging-manager-files/quarkiverse_icon_reverse.svg";
            generatedResourceProducer.produce((BuildItem)new GeneratedResourceBuildItem(logoFileName, logo));
            nativeImageResourceProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{logoFileName}));
            this.addStaticResource(generatedResourceProducer, nativeImageResourceProducer);
            loggingManagerBuildProducer.produce((BuildItem)new LoggingManagerBuildItem(UI_FINAL_DESTINATION, uiPath));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public HistoryHandlerBuildItem hander(BuildProducer<LogHandlerBuildItem> logHandlerBuildItemBuildProducer, LogStreamRecorder recorder, LoggingManagerConfig loggingManagerConfig, LaunchModeBuildItem launchMode) {
        RuntimeValue handler = recorder.logHandler(loggingManagerConfig.historySize);
        if (!launchMode.getLaunchMode().isDevOrTest() && loggingManagerConfig.ui.alwaysInclude) {
            logHandlerBuildItemBuildProducer.produce((BuildItem)new LogHandlerBuildItem(handler));
        }
        return new HistoryHandlerBuildItem((RuntimeValue<Optional<WebSocketLogHandler>>)handler);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void registerLoggingManagerUiHandler(BuildProducer<RouteBuildItem> routeProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, LoggerManagerRecorder recorder, HistoryHandlerBuildItem historyHandlerBuildItem, LoggingManagerRuntimeConfig runtimeConfig, LoggingManagerBuildItem loggingManagerBuildItem, LaunchModeBuildItem launchMode, LoggingManagerConfig loggingManagerConfig) throws Exception {
        if (LoggingManagerProcessor.shouldIncludeUi(launchMode, loggingManagerConfig)) {
            Handler handler = recorder.uiHandler(loggingManagerBuildItem.getLoggingManagerFinalDestination(), loggingManagerBuildItem.getLoggingManagerPath(), runtimeConfig);
            routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route(loggingManagerConfig.ui.rootPath).handler(handler).displayOnNotFoundPage("Quarkus Logging manager").build());
            routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route(loggingManagerConfig.ui.rootPath + "/*").handler(handler).build());
            if (!launchMode.getLaunchMode().isDevOrTest() && loggingManagerConfig.ui.alwaysInclude) {
                reflectiveClassProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new Class[]{LogStreamWebSocket.class, WebSocketLogHandler.class, LogStreamWebSocket.class, JsonFormatter.class}));
                Handler logStreamWebSocketHandler = recorder.logStreamWebSocketHandler(runtimeConfig, historyHandlerBuildItem.value);
                routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().nestedRoute(loggingManagerConfig.basePath, "logstream").handler(logStreamWebSocketHandler).build());
            }
        }
    }

    private byte[] getLogo() throws IOException {
        try (InputStream logo = LoggingManagerProcessor.class.getClassLoader().getResourceAsStream("META-INF/resources/template/quarkiverse_icon_reverse.svg");){
            byte[] byArray = IoUtil.readBytes((InputStream)logo);
            return byArray;
        }
    }

    /*
     * Exception decompiling
     */
    private String getIndexHtmlContents(String nonApplicationRootPath, String streamingPath) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String cleanFrameworkRootPath(String p) {
        if (p != null && !p.isEmpty() && p.endsWith("/")) {
            return p.substring(0, p.length() - 1);
        }
        return p;
    }

    private void addStaticResource(BuildProducer<GeneratedResourceBuildItem> generatedResourceProducer, BuildProducer<NativeImageResourceBuildItem> nativeImageResourceProducer) throws IOException, URISyntaxException {
        FileSystem fileSystem = this.getFileSystem();
        Path myPath = fileSystem.getPath(STATIC_RESOURCE_FOLDER, new String[0]);
        Stream<Path> walk = Files.walk(myPath, 5, new FileVisitOption[0]);
        Iterator it = walk.iterator();
        while (it.hasNext()) {
            Path staticResource = (Path)it.next();
            if (Files.isDirectory(staticResource, new LinkOption[0]) || !Files.isRegularFile(staticResource, new LinkOption[0])) continue;
            String fileName = "META-INF/logging-manager-files/" + staticResource.toString().substring(STATIC_RESOURCE_FOLDER.length());
            byte[] content = Files.readAllBytes(staticResource);
            generatedResourceProducer.produce((BuildItem)new GeneratedResourceBuildItem(fileName, content));
            nativeImageResourceProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{fileName}));
        }
    }

    private FileSystem getFileSystem() throws URISyntaxException, IOException {
        URI uri = null;
        try {
            uri = LoggingManagerProcessor.class.getClassLoader().getResource(STATIC_RESOURCE_FOLDER).toURI();
            return FileSystems.newFileSystem(uri, Collections.emptyMap());
        }
        catch (FileSystemAlreadyExistsException ex) {
            return FileSystems.getFileSystem(uri);
        }
    }

    private static boolean shouldIncludeUi(LaunchModeBuildItem launchMode, LoggingManagerConfig loggingManagerConfig) {
        return launchMode.getLaunchMode().isDevOrTest() || loggingManagerConfig.ui.alwaysInclude;
    }

    private static boolean shouldInclude(LaunchModeBuildItem launchMode, LoggingManagerConfig loggingManagerConfig) {
        return launchMode.getLaunchMode().isDevOrTest() || loggingManagerConfig.alwaysInclude;
    }

    public static final class HistoryHandlerBuildItem
    extends SimpleBuildItem {
        final RuntimeValue<Optional<WebSocketLogHandler>> value;

        public HistoryHandlerBuildItem(RuntimeValue<Optional<WebSocketLogHandler>> value) {
            this.value = value;
        }
    }

    static class OpenAPIIncluded
    implements BooleanSupplier {
        LoggingManagerConfig config;

        OpenAPIIncluded() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.config.openapiIncluded;
        }
    }
}

