/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.loggingmanager.deployment.devui;

import io.quarkiverse.loggingmanager.LogController;
import io.quarkiverse.loggingmanager.devui.LoggingManagerJsonRpcService;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.TableDataPageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import java.util.Map;
import java.util.stream.Collectors;

public class LoggingManagerDevUIProcessor {
    private static final String LEVEL = "level";

    @BuildStep(onlyIf={IsDevelopment.class})
    public CardPageBuildItem pages() {
        CardPageBuildItem pageBuildItem = new CardPageBuildItem();
        pageBuildItem.addBuildTimeData(LEVEL, LogController.LEVELS.stream().map(level -> Map.of(LEVEL, level)).collect(Collectors.toList()));
        pageBuildItem.addPage((PageBuilder)((TableDataPageBuilder)Page.tableDataPageBuilder((String)LEVEL).showColumn(LEVEL).buildTimeDataKey(LEVEL)).icon("font-awesome-solid:layer-group"));
        pageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().icon("font-awesome-solid:youtube")).componentLink("qwc-logging-manager-loggers.js"));
        return pageBuildItem;
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    JsonRPCProvidersBuildItem createJsonRPCService() {
        return new JsonRPCProvidersBuildItem(LoggingManagerJsonRpcService.class);
    }
}

