import { LitElement, html, css} from 'lit';
import { pages } from 'build-time-data';
import 'qwc/qwc-extension-link.js';

const NAME = "Logging Manager";
export class QwcLoggingManagerCard extends LitElement {

    static styles = css`
      .identity {
        display: flex;
        justify-content: flex-start;
      }

      .description {
        padding-bottom: 10px;
      }

      .logo {
        padding-bottom: 10px;
        margin-right: 5px;
      }

      .card-content {
        color: var(--lumo-contrast-90pct);
        display: flex;
        flex-direction: column;
        justify-content: flex-start;
        padding: 2px 2px;
        height: 100%;
      }

      .card-content slot {
        display: flex;
        flex-flow: column wrap;
        padding-top: 5px;
      }
    `;

    static properties = {
        description: {type: String}
    };

    constructor() {
        super();
    }

    connectedCallback() {
        super.connectedCallback();
    }

    render() {
        return html`<div class="card-content" slot="content">
            <div class="identity">
                <div class="logo">
                    <img src="data:image/svg+xml;base64,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"
                                       alt="${NAME}" 
                                       title="${NAME}"
                                       width="32" 
                                       height="32">
                </div>
                <div class="description">${this.description}</div>
            </div>
            ${this._renderCardLinks()}
        </div>
        `;
    }

    _renderCardLinks(){
        return html`${pages.map(page => html`
                            <qwc-extension-link slot="link"
                                extensionName="${NAME}"
                                iconName="${page.icon}"
                                displayName="${page.title}"
                                staticLabel="${page.staticLabel}"
                                dynamicLabel="${page.dynamicLabel}"
                                streamingLabel="${page.streamingLabel}"
                                path="${page.id}"
                                ?embed=${page.embed}
                                externalUrl="${page.metadata.externalUrl}"
                                webcomponent="${page.componentLink}" >
                            </qwc-extension-link>
                        `)}`;
    }

}
customElements.define('qwc-logging-manager-card', QwcLoggingManagerCard);