/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.loggingmanager.deployment;

import io.quarkiverse.loggingmanager.LoggerManagerRecorder;
import io.quarkiverse.loggingmanager.deployment.LoggingManagerConfig;
import io.quarkiverse.loggingmanager.deployment.LoggingManagerOpenAPIFilter;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.smallrye.openapi.deployment.spi.AddToOpenAPIDefinitionBuildItem;
import io.quarkus.vertx.http.deployment.BodyHandlerBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.vertx.core.Handler;
import java.util.function.BooleanSupplier;
import org.eclipse.microprofile.openapi.OASFilter;

class LoggingManagerProcessor {
    private static final String FEATURE = "logging-manager";

    LoggingManagerProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void includeRestEndpoints(BuildProducer<RouteBuildItem> routeProducer, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, LoggingManagerConfig loggingManagerConfig, BodyHandlerBuildItem bodyHandlerBuildItem, LoggerManagerRecorder recorder, LaunchModeBuildItem launchMode) {
        if ("/".equals(loggingManagerConfig.basePath())) {
            throw new ConfigurationException("quarkus.logging-manager.base-path was set to \"/\", this is not allowed as it blocks the application from serving anything else.");
        }
        if (LoggingManagerProcessor.shouldInclude(launchMode, loggingManagerConfig)) {
            Handler loggerHandler = recorder.loggerHandler();
            Handler levelHandler = recorder.levelHandler();
            routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().management().routeFunction(loggingManagerConfig.basePath(), recorder.routeConsumer(bodyHandlerBuildItem.getHandler())).displayOnNotFoundPage("LogManager All available loggers").handler(loggerHandler).build());
            routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().management().nestedRoute(loggingManagerConfig.basePath(), "levels").displayOnNotFoundPage("LogManager All available log levels").handler(levelHandler).build());
        }
    }

    @BuildStep(onlyIf={OpenAPIIncluded.class})
    public void includeInOpenAPIEndpoint(BuildProducer<AddToOpenAPIDefinitionBuildItem> openAPIProducer, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, Capabilities capabilities, LaunchModeBuildItem launchMode, LoggingManagerConfig loggingManagerConfig) {
        if (capabilities.isPresent("io.quarkus.smallrye.openapi") && LoggingManagerProcessor.shouldIncludeInOpenAPI(launchMode, loggingManagerConfig)) {
            LoggingManagerOpenAPIFilter filter = new LoggingManagerOpenAPIFilter(nonApplicationRootPathBuildItem.resolvePath(loggingManagerConfig.basePath()), loggingManagerConfig.openapiTag());
            openAPIProducer.produce((BuildItem)new AddToOpenAPIDefinitionBuildItem((OASFilter)filter));
        }
    }

    private static boolean shouldInclude(LaunchModeBuildItem launchMode, LoggingManagerConfig loggingManagerConfig) {
        return launchMode.getLaunchMode().isDevOrTest() || loggingManagerConfig.alwaysInclude();
    }

    private static boolean shouldIncludeInOpenAPI(LaunchModeBuildItem launchMode, LoggingManagerConfig loggingManagerConfig) {
        return LoggingManagerProcessor.shouldInclude(launchMode, loggingManagerConfig);
    }

    static class OpenAPIIncluded
    implements BooleanSupplier {
        LoggingManagerConfig config;

        OpenAPIIncluded() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.config.openapiIncluded();
        }
    }
}

