/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.loggingmanager.deployment.devui;

import io.quarkiverse.loggingmanager.LogController;
import io.quarkiverse.loggingmanager.devui.LoggingManagerJsonRpcService;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.TableDataPageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import java.util.Map;
import java.util.stream.Collectors;

public class LoggingManagerDevUIProcessor {
    private static final String LEVEL = "level";

    @BuildStep(onlyIf={IsDevelopment.class})
    public void pages(BuildProducer<CardPageBuildItem> cardPageBuildItemBuildProducer) {
        CardPageBuildItem card = new CardPageBuildItem();
        card.addBuildTimeData(LEVEL, LogController.LEVELS.stream().map(level -> Map.of(LEVEL, level)).collect(Collectors.toList()));
        card.addPage((PageBuilder)((TableDataPageBuilder)Page.tableDataPageBuilder((String)"Level").showColumn(LEVEL).buildTimeDataKey(LEVEL)).icon("font-awesome-solid:layer-group"));
        card.addPage((PageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().icon("font-awesome-solid:play")).componentLink("qwc-logging-manager-loggers.js"));
        card.setCustomCard("qwc-logging-manager-card.js");
        cardPageBuildItemBuildProducer.produce((BuildItem)card);
    }

    @BuildStep
    JsonRPCProvidersBuildItem createJsonRPCService() {
        return new JsonRPCProvidersBuildItem(LoggingManagerJsonRpcService.class);
    }
}

