/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.loggingmanager;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.StaticHandler;

public class LoggingManagerStaticHandler
implements Handler<RoutingContext> {
    private String loggingManagerFinalDestination;
    private String loggingManagerPath;

    public LoggingManagerStaticHandler() {
    }

    public LoggingManagerStaticHandler(String loggingManagerFinalDestination, String loggingManagerPath) {
        this.loggingManagerFinalDestination = loggingManagerFinalDestination;
        this.loggingManagerPath = loggingManagerPath;
    }

    public String getLoggingManagerFinalDestination() {
        return this.loggingManagerFinalDestination;
    }

    public void setLoggingManagerFinalDestination(String loggingManagerFinalDestination) {
        this.loggingManagerFinalDestination = loggingManagerFinalDestination;
    }

    public String getLoggingManagerPath() {
        return this.loggingManagerPath;
    }

    public void setLoggingManagerPath(String loggingManagerPath) {
        this.loggingManagerPath = loggingManagerPath;
    }

    public void handle(RoutingContext event) {
        StaticHandler staticHandler = StaticHandler.create().setAllowRootFileSystemAccess(true).setWebRoot(this.loggingManagerFinalDestination).setDefaultContentEncoding("UTF-8");
        if (event.normalizedPath().length() == this.loggingManagerPath.length()) {
            event.response().setStatusCode(302);
            event.response().headers().set(HttpHeaders.LOCATION, (CharSequence)(this.loggingManagerPath + "/"));
            event.response().end();
            return;
        }
        if (event.normalizedPath().length() == this.loggingManagerPath.length() + 1) {
            event.reroute(this.loggingManagerPath + "/index.html");
            return;
        }
        staticHandler.handle((Object)event);
    }
}

