/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.loggingmanager;

import io.quarkiverse.loggingmanager.LevelHandler;
import io.quarkiverse.loggingmanager.LoggerHandler;
import io.quarkiverse.loggingmanager.LoggingManagerNotFoundHandler;
import io.quarkiverse.loggingmanager.LoggingManagerRuntimeConfig;
import io.quarkiverse.loggingmanager.LoggingManagerStaticHandler;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.http.runtime.logstream.LogStreamWebSocket;
import io.quarkus.vertx.http.runtime.logstream.WebSocketLogHandler;
import io.vertx.core.Handler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import java.util.Optional;
import java.util.function.Consumer;

@Recorder
public class LoggerManagerRecorder {
    public Handler<RoutingContext> loggerHandler() {
        return new LoggerHandler();
    }

    public Handler<RoutingContext> levelHandler() {
        return new LevelHandler();
    }

    public Handler<RoutingContext> uiHandler(String loggingManagerFinalDestination, String loggingManagerPath, LoggingManagerRuntimeConfig runtimeConfig) {
        if (runtimeConfig.enableUi) {
            return new LoggingManagerStaticHandler(loggingManagerFinalDestination, loggingManagerPath);
        }
        return new LoggingManagerNotFoundHandler();
    }

    public Handler<RoutingContext> logStreamWebSocketHandler(LoggingManagerRuntimeConfig runtimeConfig, RuntimeValue<Optional<WebSocketLogHandler>> historyHandler) {
        if (runtimeConfig.enableUi) {
            return new LogStreamWebSocket((WebSocketLogHandler)((Optional)historyHandler.getValue()).get());
        }
        return new LoggingManagerNotFoundHandler();
    }

    public Consumer<Route> routeConsumer(final Handler<RoutingContext> bodyHandler, LoggingManagerRuntimeConfig runtimeConfig) {
        if (runtimeConfig.enable) {
            return new Consumer<Route>(){

                @Override
                public void accept(Route route) {
                    route.handler(bodyHandler);
                }
            };
        }
        return new Consumer<Route>(){

            @Override
            public void accept(Route route) {
                route.handler((Handler)new LoggingManagerNotFoundHandler());
            }
        };
    }
}

