/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.logging.sentry;

import io.quarkus.logging.sentry.SentryBeforeSendCallbacksHandler;
import io.quarkus.logging.sentry.SentryConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.sentry.SentryOptions;
import io.sentry.jul.SentryHandler;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Handler;
import org.jboss.logging.Logger;

@Recorder
public class SentryHandlerValueFactory {
    private static final Logger LOG = Logger.getLogger(SentryHandlerValueFactory.class);
    private final RuntimeValue<SentryConfig> sentryConfig;

    public SentryHandlerValueFactory(RuntimeValue<SentryConfig> sentryConfig) {
        this.sentryConfig = sentryConfig;
    }

    public RuntimeValue<Optional<Handler>> create() {
        SentryConfig config = (SentryConfig)this.sentryConfig.getValue();
        if (!config.enabled()) {
            return new RuntimeValue(Optional.empty());
        }
        SentryOptions options = SentryHandlerValueFactory.toSentryOptions(config);
        boolean enableExternalConfiguration = false;
        SentryHandler handler = new SentryHandler(options, false);
        handler.setLevel(config.level());
        handler.setPrintfStyle(true);
        try {
            handler.setEncoding(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)"Could not set encoding for Sentry handler", (Throwable)e);
        }
        handler.setMinimumEventLevel(config.minimumEventLevel() != null ? config.minimumEventLevel() : config.level());
        handler.setMinimumBreadcrumbLevel(config.minimumBreadcrumbLevel());
        LOG.infof("Sentry connected to: %s", (Object)config.dsn().orElse("?"));
        return new RuntimeValue(Optional.of(handler));
    }

    public static SentryOptions toSentryOptions(SentryConfig sentryConfig) {
        SentryOptions options;
        block11: {
            List<String> inAppPackages;
            block12: {
                block10: {
                    if (sentryConfig.dsn().isEmpty()) {
                        throw new ConfigurationException("Configuration key \"quarkus.log.sentry.dsn\" is required when Sentry is enabled, but its value is empty/missing");
                    }
                    options = new SentryOptions();
                    if (!sentryConfig.inAppPackages().isEmpty()) break block10;
                    LOG.warn((Object)"No 'quarkus.log.sentry.in-app-packages' was configured, this option is highly recommended as it affects stacktrace grouping and display on Sentry. See https://quarkus.io/guides/logging-sentry#in-app-packages");
                    break block11;
                }
                inAppPackages = sentryConfig.inAppPackages().get();
                if (inAppPackages.size() != 1) break block12;
                if (Objects.equals(inAppPackages.get(0), "*")) break block11;
            }
            inAppPackages.forEach(arg_0 -> ((SentryOptions)options).addInAppInclude(arg_0));
        }
        if (sentryConfig.inAppExcludedPackages().isPresent()) {
            List<String> inAppExcludedPackages = sentryConfig.inAppExcludedPackages().get();
            inAppExcludedPackages.forEach(arg_0 -> ((SentryOptions)options).addInAppExclude(arg_0));
        }
        if (sentryConfig.ignoredExceptionsForType().isPresent()) {
            List<String> ignoredExceptionsForType = sentryConfig.ignoredExceptionsForType().get();
            ignoredExceptionsForType.forEach(exceptionTypeName -> {
                try {
                    Class<Throwable> exceptionClass = Class.forName(exceptionTypeName).asSubclass(Throwable.class);
                    options.addIgnoredExceptionForType(exceptionClass);
                }
                catch (ClassNotFoundException e) {
                    LOG.error((Object)String.format("Exception type not found for the given name: %s, in 'quarkus.log.sentry.ignored-exceptions-for-type'", exceptionTypeName), (Throwable)e);
                }
            });
        }
        options.setDsn(sentryConfig.dsn().get());
        sentryConfig.environment().ifPresent(arg_0 -> ((SentryOptions)options).setEnvironment(arg_0));
        sentryConfig.release().ifPresent(arg_0 -> ((SentryOptions)options).setRelease(arg_0));
        sentryConfig.ignoredErrors().ifPresent(arg_0 -> ((SentryOptions)options).setIgnoredErrors(arg_0));
        sentryConfig.serverName().ifPresent(arg_0 -> ((SentryOptions)options).setServerName(arg_0));
        sentryConfig.tracesSampleRate().ifPresent(arg_0 -> ((SentryOptions)options).setTracesSampleRate(arg_0));
        sentryConfig.contextTags().ifPresent(contextTags -> contextTags.forEach(arg_0 -> ((SentryOptions)options).addContextTag(arg_0)));
        sentryConfig.tags().forEach((arg_0, arg_1) -> ((SentryOptions)options).setTag(arg_0, arg_1));
        Instance select = CDI.current().select(SentryOptions.BeforeSendCallback.class, new Annotation[0]);
        if (!select.isUnsatisfied()) {
            SentryBeforeSendCallbacksHandler handler = new SentryBeforeSendCallbacksHandler((Instance<SentryOptions.BeforeSendCallback>)select);
            options.setBeforeSend(handler::apply);
        }
        if (sentryConfig.proxy().enabled()) {
            if (sentryConfig.proxy().host().filter(Predicate.not(String::isBlank)).isPresent()) {
                LOG.trace((Object)"Proxy is enabled for Sentry's outgoing requests");
                options.setProxy(new SentryOptions.Proxy(sentryConfig.proxy().host().orElseThrow(), (String)sentryConfig.proxy().port().map(String::valueOf).orElse(null), (String)sentryConfig.proxy().username().orElse(null), (String)sentryConfig.proxy().password().orElse(null)));
            } else {
                LOG.warn((Object)"Proxy is enabled for Sentry but no host is provided. Ignoring Proxy configuration.");
            }
        }
        options.setDebug(sentryConfig.debug());
        return options;
    }
}

