/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.lucene.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import org.apache.lucene.analysis.charfilter.MappingCharFilterFactory;
import org.apache.lucene.analysis.core.KeywordTokenizerFactory;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.core.StopFilterFactory;
import org.apache.lucene.analysis.core.UpperCaseFilterFactory;
import org.apache.lucene.analysis.core.WhitespaceTokenizerFactory;
import org.apache.lucene.analysis.en.PorterStemFilterFactory;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterGraphFilterFactory;
import org.apache.lucene.analysis.ngram.EdgeNGramFilterFactory;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenizerFactory;
import org.apache.lucene.analysis.ngram.NGramFilterFactory;
import org.apache.lucene.analysis.ngram.NGramTokenizerFactory;
import org.apache.lucene.analysis.path.PathHierarchyTokenizerFactory;
import org.apache.lucene.analysis.pattern.PatternReplaceCharFilterFactory;
import org.apache.lucene.analysis.pattern.PatternReplaceFilterFactory;
import org.apache.lucene.analysis.pattern.PatternTokenizerFactory;
import org.apache.lucene.analysis.shingle.ShingleFilterFactory;
import org.apache.lucene.analysis.snowball.SnowballPorterFilterFactory;
import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.apache.lucene.analysis.synonym.SynonymGraphFilterFactory;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.tartarus.snowball.ext.EnglishStemmer;

class LuceneProcessor {
    private static final String FEATURE = "lucene";

    LuceneProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void commonTokenizerReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        this.addCtorReflection(reflectiveClass, StandardTokenizerFactory.class);
        this.addCtorReflection(reflectiveClass, LowerCaseFilterFactory.class);
        this.addCtorReflection(reflectiveClass, EdgeNGramTokenizerFactory.class);
        this.addCtorReflection(reflectiveClass, PathHierarchyTokenizerFactory.class);
        this.addCtorReflection(reflectiveClass, WhitespaceTokenizerFactory.class);
        this.addCtorReflection(reflectiveClass, PatternTokenizerFactory.class);
        this.addCtorReflection(reflectiveClass, KeywordTokenizerFactory.class);
        this.addCtorReflection(reflectiveClass, NGramTokenizerFactory.class);
        this.addCtorReflection(reflectiveClass, EdgeNGramFilterFactory.class);
        this.addCtorReflection(reflectiveClass, LowerCaseFilterFactory.class);
        this.addCtorReflection(reflectiveClass, ShingleFilterFactory.class);
        this.addCtorReflection(reflectiveClass, StopFilterFactory.class);
        this.addCtorReflection(reflectiveClass, SynonymGraphFilterFactory.class);
        this.addCtorReflection(reflectiveClass, SnowballPorterFilterFactory.class);
        this.addCtorReflection(reflectiveClass, UpperCaseFilterFactory.class);
        this.addCtorReflection(reflectiveClass, PatternReplaceFilterFactory.class);
        this.addCtorReflection(reflectiveClass, PorterStemFilterFactory.class);
        this.addCtorReflection(reflectiveClass, NGramFilterFactory.class);
        this.addCtorReflection(reflectiveClass, ShingleFilterFactory.class);
        this.addCtorReflection(reflectiveClass, WordDelimiterGraphFilterFactory.class);
        this.addCtorReflection(reflectiveClass, EnglishStemmer.class);
        this.addCtorReflection(reflectiveClass, CharFilterFactory.class);
        this.addCtorReflection(reflectiveClass, MappingCharFilterFactory.class);
        this.addCtorReflection(reflectiveClass, PatternReplaceCharFilterFactory.class);
        this.addCtorReflection(reflectiveClass, MMapDirectory.class);
        this.addCtorReflection(reflectiveClass, ByteBuffersDirectory.class);
        this.addCtorReflection(reflectiveClass, NIOFSDirectory.class);
        this.addCtorReflection(reflectiveClass, RAMDirectory.class);
        this.addCtorReflection(reflectiveClass, SimpleFSDirectory.class);
    }

    private void addCtorReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, Class<?> clazz) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new Class[]{clazz}));
    }
}

