/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mavenresolver;

import io.quarkiverse.mavenresolver.MavenResolverRuntimeConfig;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

@Singleton
public class BootstrapMavenContextProducer {
    private final BootstrapMavenContext mvnCtx;
    private MavenArtifactResolver resolver;

    public BootstrapMavenContextProducer(RepositorySystem repoSystem, RemoteRepositoryManager remoteRepoManager, MavenResolverRuntimeConfig config) {
        try {
            BootstrapMavenContext tmp = new BootstrapMavenContext(BootstrapMavenContext.config().setWorkspaceDiscovery(false).setRepositorySystem(repoSystem).setRemoteRepositoryManager(remoteRepoManager));
            List<RemoteRepository> missingRepos = BootstrapMavenContextProducer.getMissingRepos(tmp, config.repositories().repos());
            if (missingRepos.isEmpty()) {
                this.mvnCtx = tmp;
            } else {
                tmp.getRemoteRepositoryManager().aggregateRepositories(tmp.getRepositorySystemSession(), missingRepos, tmp.getRemoteRepositories(), false);
                this.mvnCtx = new BootstrapMavenContext(BootstrapMavenContext.config().setWorkspaceDiscovery(false).setRepositorySystem(repoSystem).setRemoteRepositoryManager(remoteRepoManager).setRepositorySystemSession(tmp.getRepositorySystemSession()).setRemoteRepositories(tmp.getRemoteRepositoryManager().aggregateRepositories(tmp.getRepositorySystemSession(), missingRepos, tmp.getRemoteRepositories(), false)));
            }
        }
        catch (BootstrapMavenException e) {
            throw new IllegalStateException("Failed to initialize bootstrap Maven context", e);
        }
    }

    @Produces
    public MavenArtifactResolver produceResolver(BootstrapMavenContext mvnCtx) {
        return this.resolver == null ? (this.resolver = this.newResolver()) : this.resolver;
    }

    private MavenArtifactResolver newResolver() {
        try {
            return new MavenArtifactResolver(this.mvnCtx);
        }
        catch (BootstrapMavenException e) {
            throw new IllegalStateException("Failed to initialize Maven artifact resolver", e);
        }
    }

    @Produces
    public BootstrapMavenContext bootstrapMavenContext() {
        return this.mvnCtx;
    }

    private static List<RemoteRepository> getMissingRepos(BootstrapMavenContext mavenContext, Map<String, MavenResolverRuntimeConfig.RepositoryRuntimeConfig> extraRepos) throws BootstrapMavenException {
        if (extraRepos.isEmpty()) {
            return List.of();
        }
        ArrayList<RemoteRepository> extraList = new ArrayList<RemoteRepository>(extraRepos.size());
        for (Map.Entry<String, MavenResolverRuntimeConfig.RepositoryRuntimeConfig> r : extraRepos.entrySet()) {
            if (BootstrapMavenContextProducer.isRepositoryConfigured(mavenContext.getRemoteRepositories(), r.getValue().url())) continue;
            extraList.add(new RemoteRepository.Builder(r.getKey(), "default", r.getValue().url()).build());
        }
        if (extraList.isEmpty()) {
            return List.of();
        }
        return mavenContext.getRemoteRepositoryManager().aggregateRepositories(mavenContext.getRepositorySystemSession(), List.of(), extraList, true);
    }

    private static boolean isRepositoryConfigured(List<RemoteRepository> repos, String url) {
        for (RemoteRepository repo : repos) {
            if (!BootstrapMavenContextProducer.isRepositoryConfigured(repo, url)) continue;
            return true;
        }
        return false;
    }

    private static boolean isRepositoryConfigured(RemoteRepository repo, String url) {
        if (repo.getUrl().startsWith(url)) {
            return true;
        }
        return !repo.getMirroredRepositories().isEmpty() && BootstrapMavenContextProducer.isRepositoryConfigured(repo.getMirroredRepositories(), url);
    }
}

