/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mavenresolver;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Singleton;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.impl.RemoteRepositoryManager;

@Singleton
public class MavenRepositorySystemProducer {
    private final RepositorySystem repoSystem;
    private final RemoteRepositoryManager remoteRepoManager;

    public MavenRepositorySystemProducer() {
        try {
            BootstrapMavenContext mvnCtx = new BootstrapMavenContext(BootstrapMavenContext.config().setWorkspaceDiscovery(false));
            this.repoSystem = mvnCtx.getRepositorySystem();
            this.remoteRepoManager = mvnCtx.getRemoteRepositoryManager();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to initialize Maven context", e);
        }
    }

    @Produces
    public RepositorySystem getRepositorySystem() {
        return this.repoSystem;
    }

    @Produces
    public RemoteRepositoryManager getRemoteRepositoryManager() {
        return this.remoteRepoManager;
    }
}

