/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.sse.deployment;

import io.quarkiverse.mcp.server.sse.runtime.SseMcpMessageHandler;
import io.quarkiverse.mcp.server.sse.runtime.SseMcpServerRecorder;
import io.quarkiverse.mcp.server.sse.runtime.StreamableHttpMcpMessageHandler;
import io.quarkiverse.mcp.server.sse.runtime.config.McpSseBuildTimeConfig;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.vertx.http.deployment.BodyHandlerBuildItem;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.spi.RouteBuildItem;

public class SseMcpServerProcessor {
    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("mcp-server-sse");
    }

    @BuildStep
    void addBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{SseMcpMessageHandler.class, StreamableHttpMcpMessageHandler.class}).build());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=SyntheticBeansRuntimeInitBuildItem.class)
    @BuildStep
    void registerEndpoints(McpSseBuildTimeConfig config, HttpRootPathBuildItem rootPath, SseMcpServerRecorder recorder, BodyHandlerBuildItem bodyHandler, BuildProducer<RouteBuildItem> routes) {
        String mcpPath = rootPath.relativePath(config.rootPath());
        routes.produce((BuildItem)RouteBuildItem.newFrameworkRoute((String)mcpPath).withRouteCustomizer(recorder.addBodyHandler(bodyHandler.getHandler())).withRequestHandler(recorder.createMcpEndpointHandler()).build());
        routes.produce((BuildItem)RouteBuildItem.newFrameworkRoute((String)(mcpPath.endsWith("/") ? mcpPath + "sse" : mcpPath + "/sse")).withRequestHandler(recorder.createSseEndpointHandler(mcpPath)).build());
        routes.produce((BuildItem)RouteBuildItem.newFrameworkRoute((String)(mcpPath + "/messages/:id")).withRouteCustomizer(recorder.addBodyHandler(bodyHandler.getHandler())).withRequestHandler(recorder.createMessagesEndpointHandler()).build());
    }
}

