/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.sse.deployment;

import io.quarkiverse.mcp.server.deployment.ServerNameBuildItem;
import io.quarkiverse.mcp.server.sse.runtime.SseMcpMessageHandler;
import io.quarkiverse.mcp.server.sse.runtime.SseMcpServerRecorder;
import io.quarkiverse.mcp.server.sse.runtime.StreamableHttpMcpMessageHandler;
import io.quarkiverse.mcp.server.sse.runtime.config.McpSseServerBuildTimeConfig;
import io.quarkiverse.mcp.server.sse.runtime.config.McpSseServersBuildTimeConfig;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.ObserverRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.arc.processor.ObserverConfigurator;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.Gizmo;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.vertx.http.HttpServerStart;
import io.quarkus.vertx.http.HttpsServerStart;
import io.quarkus.vertx.http.deployment.BodyHandlerBuildItem;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.spi.RouteBuildItem;
import io.vertx.core.http.HttpServerOptions;
import jakarta.enterprise.inject.spi.EventContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.DotName;

public class SseMcpServerProcessor {
    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("mcp-server-sse");
    }

    @BuildStep
    void addBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{SseMcpMessageHandler.class, StreamableHttpMcpMessageHandler.class}).build());
    }

    @BuildStep
    void serverNames(McpSseServersBuildTimeConfig config, BuildProducer<ServerNameBuildItem> serverNames) {
        for (String serverName : config.servers().keySet()) {
            serverNames.produce((BuildItem)new ServerNameBuildItem(serverName));
        }
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=SyntheticBeansRuntimeInitBuildItem.class)
    @BuildStep
    void registerEndpoints(McpSseServersBuildTimeConfig config, HttpRootPathBuildItem httpRootPath, SseMcpServerRecorder recorder, BodyHandlerBuildItem bodyHandler, BuildProducer<RouteBuildItem> routes, ObserverRegistrationPhaseBuildItem observerRegistrationPhase, BuildProducer<ObserverRegistrationPhaseBuildItem.ObserverConfiguratorBuildItem> observers) {
        HashSet<String> rootPaths = new HashSet<String>();
        ArrayList<SseMcpServerRecorder.McpServerEndpoints> endpoints = new ArrayList<SseMcpServerRecorder.McpServerEndpoints>();
        for (Map.Entry e : config.servers().entrySet()) {
            String serverName = (String)e.getKey();
            String rootPath = ((McpSseServerBuildTimeConfig)e.getValue()).sse().rootPath();
            if (!rootPaths.add(rootPath)) {
                throw new IllegalStateException("Multiple server configurations define the same root path: " + rootPath);
            }
            String mcpPath = httpRootPath.relativePath(rootPath);
            routes.produce((BuildItem)RouteBuildItem.newFrameworkRoute((String)mcpPath).withRouteCustomizer(recorder.addBodyHandler(bodyHandler.getHandler())).withRequestHandler(recorder.createMcpEndpointHandler(serverName)).build());
            String ssePath = mcpPath.endsWith("/") ? mcpPath + "sse" : mcpPath + "/sse";
            routes.produce((BuildItem)RouteBuildItem.newFrameworkRoute((String)ssePath).withRequestHandler(recorder.createSseEndpointHandler(mcpPath, serverName)).build());
            routes.produce((BuildItem)RouteBuildItem.newFrameworkRoute((String)(mcpPath + "/messages/:id")).withRouteCustomizer(recorder.addBodyHandler(bodyHandler.getHandler())).withRequestHandler(recorder.createMessagesEndpointHandler(serverName)).build());
            endpoints.add(new SseMcpServerRecorder.McpServerEndpoints(serverName, mcpPath, ssePath));
        }
        ObserverConfigurator httpStartConfigurator = observerRegistrationPhase.getContext().configure().async(true).beanClass(DotName.createSimple(SseMcpServerRecorder.class)).observedType(HttpServerStart.class).notify(mc -> this.logMcpServerEndpoints(HttpServerStart.class, (MethodCreator)mc, (List<SseMcpServerRecorder.McpServerEndpoints>)endpoints));
        ObserverConfigurator httpsStartConfigurator = observerRegistrationPhase.getContext().configure().async(true).beanClass(DotName.createSimple(SseMcpServerRecorder.class)).observedType(HttpsServerStart.class).notify(mc -> this.logMcpServerEndpoints(HttpsServerStart.class, (MethodCreator)mc, (List<SseMcpServerRecorder.McpServerEndpoints>)endpoints));
        observers.produce((BuildItem)new ObserverRegistrationPhaseBuildItem.ObserverConfiguratorBuildItem(new ObserverConfigurator[]{httpStartConfigurator, httpsStartConfigurator}));
    }

    private void logMcpServerEndpoints(Class<?> eventType, MethodCreator mc, List<SseMcpServerRecorder.McpServerEndpoints> endpoints) {
        ResultHandle event = mc.invokeInterfaceMethod(MethodDescriptor.ofMethod(EventContext.class, (String)"getEvent", Object.class, (Class[])new Class[0]), mc.getMethodParam(0), new ResultHandle[0]);
        ResultHandle httpServerOptions = mc.invokeVirtualMethod(MethodDescriptor.ofMethod(eventType, (String)"options", HttpServerOptions.class, (Class[])new Class[0]), event, new ResultHandle[0]);
        ResultHandle list = Gizmo.newArrayList((BytecodeCreator)mc);
        for (SseMcpServerRecorder.McpServerEndpoints e : endpoints) {
            ResultHandle mcpe = mc.newInstance(MethodDescriptor.ofConstructor(SseMcpServerRecorder.McpServerEndpoints.class, (Class[])new Class[]{String.class, String.class, String.class}), new ResultHandle[]{mc.load(e.serverName), mc.load(e.mcpPath), mc.load(e.ssePath)});
            Gizmo.listOperations((BytecodeCreator)mc).on(list).add(mcpe);
        }
        mc.invokeStaticMethod(MethodDescriptor.ofMethod(SseMcpServerRecorder.class, (String)"logEndpoints", Void.TYPE, (Class[])new Class[]{List.class, HttpServerOptions.class}), new ResultHandle[]{list, httpServerOptions});
        mc.returnVoid();
    }
}

