/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.sse.runtime;

import io.quarkiverse.mcp.server.McpLog;
import io.quarkiverse.mcp.server.runtime.McpConnectionBase;
import io.quarkiverse.mcp.server.runtime.TrafficLogger;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import java.time.Duration;
import java.util.Optional;

public class SseMcpConnection
extends McpConnectionBase {
    private final HttpServerResponse response;

    SseMcpConnection(String id, McpLog.LogLevel defaultLogLevel, TrafficLogger trafficLogger, Optional<Duration> autoPingInterval, HttpServerResponse response) {
        super(id, defaultLogLevel, trafficLogger, autoPingInterval);
        this.response = response;
    }

    public void sendEvent(String name, String data) {
        this.response.write("event: " + name + "\ndata: " + data + "\n\n");
    }

    public void send(JsonObject message) {
        if (message == null) {
            return;
        }
        if (this.trafficLogger != null) {
            this.trafficLogger.messageSent(message);
        }
        this.sendEvent("message", message.encode());
    }
}

