/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.sse.runtime;

import io.quarkiverse.mcp.server.McpConnection;
import io.quarkiverse.mcp.server.McpLog;
import io.quarkiverse.mcp.server.runtime.McpConnectionBase;
import io.quarkiverse.mcp.server.runtime.TrafficLogger;
import io.vertx.core.Future;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import java.time.Duration;
import java.util.Optional;

public class SseMcpConnection
extends McpConnectionBase {
    private final HttpServerResponse response;

    SseMcpConnection(String id, McpLog.LogLevel defaultLogLevel, TrafficLogger trafficLogger, Optional<Duration> autoPingInterval, HttpServerResponse response) {
        super(id, defaultLogLevel, trafficLogger, autoPingInterval);
        this.response = response;
    }

    public Future<Void> sendEvent(String name, String data) {
        return this.response.write("event: " + name + "\ndata: " + data + "\n\n");
    }

    public Future<Void> send(JsonObject message) {
        if (message == null) {
            return Future.succeededFuture();
        }
        if (this.trafficLogger != null) {
            this.trafficLogger.messageSent(message, (McpConnection)this);
        }
        return this.sendEvent("message", message.encode());
    }
}

