/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.sse.runtime;

import io.quarkiverse.mcp.server.runtime.ConnectionManager;
import io.quarkiverse.mcp.server.runtime.ContextSupport;
import io.quarkiverse.mcp.server.runtime.McpConnectionBase;
import io.quarkiverse.mcp.server.runtime.McpMessageHandler;
import io.quarkiverse.mcp.server.runtime.McpMetadata;
import io.quarkiverse.mcp.server.runtime.McpRequest;
import io.quarkiverse.mcp.server.runtime.McpRequestImpl;
import io.quarkiverse.mcp.server.runtime.NotificationManagerImpl;
import io.quarkiverse.mcp.server.runtime.PromptCompletionManagerImpl;
import io.quarkiverse.mcp.server.runtime.PromptManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResourceManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResourceTemplateCompletionManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResourceTemplateManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResponseHandlers;
import io.quarkiverse.mcp.server.runtime.SecuritySupport;
import io.quarkiverse.mcp.server.runtime.Sender;
import io.quarkiverse.mcp.server.runtime.ToolManagerImpl;
import io.quarkiverse.mcp.server.runtime.config.McpRuntimeConfig;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.Json;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Singleton;
import org.jboss.logging.Logger;

@Singleton
public class SseMcpMessageHandler
extends McpMessageHandler<McpRequestImpl>
implements Handler<RoutingContext> {
    private static final Logger LOG = Logger.getLogger(SseMcpMessageHandler.class);
    private final CurrentVertxRequest currentVertxRequest;
    private final CurrentIdentityAssociation currentIdentityAssociation;

    protected SseMcpMessageHandler(McpRuntimeConfig config, ConnectionManager connectionManager, PromptManagerImpl promptManager, ToolManagerImpl toolManager, ResourceManagerImpl resourceManager, PromptCompletionManagerImpl promptCompleteManager, ResourceTemplateManagerImpl resourceTemplateManager, ResourceTemplateCompletionManagerImpl resourceTemplateCompleteManager, NotificationManagerImpl initManager, ResponseHandlers serverRequests, CurrentVertxRequest currentVertxRequest, Instance<CurrentIdentityAssociation> currentIdentityAssociation, McpMetadata metadata) {
        super(config, connectionManager, promptManager, toolManager, resourceManager, promptCompleteManager, resourceTemplateManager, resourceTemplateCompleteManager, initManager, serverRequests, metadata);
        this.currentVertxRequest = currentVertxRequest;
        this.currentIdentityAssociation = currentIdentityAssociation.isResolvable() ? (CurrentIdentityAssociation)currentIdentityAssociation.get() : null;
    }

    public void handle(final RoutingContext ctx) {
        Object json;
        HttpServerRequest request = ctx.request();
        String connectionId = ctx.pathParam("id");
        if (connectionId == null) {
            LOG.errorf("Connection id is missing: %s", (Object)ctx.normalizedPath());
            ctx.fail(400);
            return;
        }
        if (request.method() != HttpMethod.POST) {
            ctx.response().putHeader(HttpHeaders.ALLOW, (CharSequence)"POST");
            LOG.errorf("Invalid HTTP method %s [connectionId: %s]", (Object)ctx.request().method(), (Object)connectionId);
            ctx.fail(405);
            return;
        }
        McpConnectionBase connection = this.connectionManager.get(connectionId);
        if (connection == null) {
            LOG.errorf("Connection not found: %s", (Object)connectionId);
            ctx.fail(400);
            return;
        }
        try {
            json = Json.decodeValue((Buffer)ctx.body().buffer());
        }
        catch (Exception e) {
            String msg = "Unable to parse the JSON message";
            LOG.errorf((Throwable)e, msg, new Object[0]);
            connection.sendError(null, -32700, msg);
            ctx.end();
            return;
        }
        final QuarkusHttpUser user = (QuarkusHttpUser)ctx.user();
        SecuritySupport securitySupport = new SecuritySupport(){

            public void setCurrentIdentity(CurrentIdentityAssociation currentIdentityAssociation) {
                if (user != null) {
                    SecurityIdentity identity = user.getSecurityIdentity();
                    currentIdentityAssociation.setIdentity(identity);
                } else {
                    currentIdentityAssociation.setIdentity(QuarkusHttpUser.getSecurityIdentity((RoutingContext)ctx, null));
                }
            }
        };
        ContextSupport contextSupport = new ContextSupport(){

            public void requestContextActivated() {
                SseMcpMessageHandler.this.currentVertxRequest.setCurrent(ctx);
            }
        };
        McpRequestImpl mcpRequest = new McpRequestImpl(json, connection, (Sender)connection, securitySupport, contextSupport);
        this.handle((McpRequest)mcpRequest).onComplete(ar -> {
            if (ar.succeeded()) {
                ctx.end();
            } else {
                ctx.response().setStatusCode(500).end();
            }
        });
    }

    protected CurrentIdentityAssociation currentIdentityAssociation() {
        return this.currentIdentityAssociation;
    }
}

