/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.sse.runtime;

import io.quarkiverse.mcp.server.runtime.ConnectionManager;
import io.quarkiverse.mcp.server.runtime.McpConnectionBase;
import io.quarkiverse.mcp.server.runtime.TrafficLogger;
import io.quarkiverse.mcp.server.runtime.config.McpRuntimeConfig;
import io.quarkiverse.mcp.server.sse.runtime.SseMcpConnection;
import io.quarkiverse.mcp.server.sse.runtime.SseMcpMessageHandler;
import io.quarkiverse.mcp.server.sse.runtime.StreamableHttpMcpMessageHandler;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

@Recorder
public class SseMcpServerRecorder {
    private static final Logger LOG = Logger.getLogger(SseMcpServerRecorder.class);
    private final McpRuntimeConfig config;

    public SseMcpServerRecorder(McpRuntimeConfig config) {
        this.config = config;
    }

    public Handler<RoutingContext> createMcpEndpointHandler() {
        final StreamableHttpMcpMessageHandler handler = (StreamableHttpMcpMessageHandler)((Object)Arc.container().instance(StreamableHttpMcpMessageHandler.class, new Annotation[0]).get());
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext ctx) {
                HttpMethod method = ctx.request().method();
                if (HttpMethod.GET.equals((Object)method)) {
                    SseMcpServerRecorder.this.openSseStream(ctx);
                } else if (HttpMethod.POST.equals((Object)method)) {
                    handler.handle(ctx);
                } else if (HttpMethod.DELETE.equals((Object)method)) {
                    handler.terminateSession(ctx);
                } else {
                    throw new IllegalArgumentException("Unexpected HTTP method: " + String.valueOf(method));
                }
            }
        };
    }

    private void openSseStream(RoutingContext ctx) {
        ctx.response().setStatusCode(405).end();
    }

    public Handler<RoutingContext> createSseEndpointHandler(final String mcpPath) {
        ArcContainer container = Arc.container();
        final ConnectionManager connectionManager = (ConnectionManager)container.instance(ConnectionManager.class, new Annotation[0]).get();
        final TrafficLogger trafficLogger = this.config.trafficLogging().enabled() ? new TrafficLogger(this.config.trafficLogging().textLimit()) : null;
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext ctx) {
                HttpServerResponse response = ctx.response();
                response.setChunked(true);
                response.headers().add(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/event-stream");
                String id = ConnectionManager.connectionId();
                LOG.debugf("SSE connection initialized [%s]", (Object)id);
                SseMcpConnection connection = new SseMcpConnection(id, SseMcpServerRecorder.this.config.clientLogging().defaultLevel(), trafficLogger, SseMcpServerRecorder.this.config.autoPingInterval(), response);
                connectionManager.add((McpConnectionBase)connection);
                SseMcpServerRecorder.this.setCloseHandler(ctx.request(), id, connectionManager);
                String endpointPath = mcpPath.endsWith("/") ? mcpPath + "messages/" + id : mcpPath + "/messages/" + id;
                LOG.debugf("POST endpoint path: %s", (Object)endpointPath);
                connection.sendEvent("endpoint", endpointPath);
            }
        };
    }

    private void setCloseHandler(HttpServerRequest request, final String connectionId, final ConnectionManager connectionManager) {
        HttpConnection connection = request.connection();
        if (connection instanceof ConnectionBase) {
            ConnectionBase base = (ConnectionBase)connection;
            try {
                MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(ConnectionBase.class, MethodHandles.lookup());
                VarHandle varHandle = lookup.findVarHandle(ConnectionBase.class, "closeHandler", Handler.class);
                final Handler closeHandler = varHandle.get(base);
                base.closeHandler((Handler)new Handler<Void>(){

                    public void handle(Void event) {
                        if (closeHandler != null) {
                            closeHandler.handle((Object)event);
                        }
                        if (connectionManager.remove(connectionId)) {
                            LOG.debugf("Connection %s closed", (Object)connectionId);
                        }
                    }
                });
            }
            catch (Exception e) {
                LOG.warnf((Throwable)e, "Unable to set close handler - client should close the connection [%s] explicitly", (Object)connectionId);
            }
        } else {
            LOG.warnf("Unable to set close handler - client should close the connection [%s] explicitly", (Object)connectionId);
        }
    }

    public Consumer<Route> addBodyHandler(final Handler<RoutingContext> bodyHandler) {
        return new Consumer<Route>(){

            @Override
            public void accept(Route route) {
                route.handler(bodyHandler);
            }
        };
    }

    public Handler<RoutingContext> createMessagesEndpointHandler() {
        return (Handler)Arc.container().instance(SseMcpMessageHandler.class, new Annotation[0]).get();
    }
}

