/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.sse.runtime.devui;

import io.quarkiverse.mcp.server.CompletionManager;
import io.quarkiverse.mcp.server.PromptCompletionManager;
import io.quarkiverse.mcp.server.PromptManager;
import io.quarkiverse.mcp.server.ResourceManager;
import io.quarkiverse.mcp.server.ResourceTemplateCompletionManager;
import io.quarkiverse.mcp.server.ResourceTemplateManager;
import io.quarkiverse.mcp.server.ToolManager;
import io.quarkiverse.mcp.server.sse.client.SseClient;
import io.quarkiverse.mcp.server.sse.runtime.config.McpSseBuildTimeConfig;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.context.ApplicationScoped;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@ApplicationScoped
public class SseMcpJsonRPCService {
    private static final Logger LOG = Logger.getLogger(SseMcpJsonRPCService.class);
    private final ToolManager toolManager;
    private final PromptManager promptManager;
    private final PromptCompletionManager promptCompletionManager;
    private final ResourceManager resourceManager;
    private final ResourceTemplateManager resourceTemplateManager;
    private final ResourceTemplateCompletionManager resourceTemplateCompletionManager;
    private final URI sseEndpoint;
    private final DevUIClient client;
    private final HttpClient httpClient;

    public SseMcpJsonRPCService(ToolManager toolManager, PromptManager promptManager, ResourceManager resourceManager, ResourceTemplateManager resourceTemplateManager, PromptCompletionManager promptCompletionManager, ResourceTemplateCompletionManager resourceTemplateCompletionManager, @ConfigProperty(name="quarkus.http.host") String host, @ConfigProperty(name="quarkus.http.port") int port, @ConfigProperty(name="quarkus.http.root-path") String rootPath, McpSseBuildTimeConfig mcpSseBuildConfig) {
        this.toolManager = toolManager;
        this.promptManager = promptManager;
        this.promptCompletionManager = promptCompletionManager;
        this.resourceManager = resourceManager;
        this.resourceTemplateManager = resourceTemplateManager;
        this.resourceTemplateCompletionManager = resourceTemplateCompletionManager;
        this.sseEndpoint = URI.create("http://" + host + ":" + port + rootPath + this.pathToAppend(rootPath, mcpSseBuildConfig.rootPath()) + this.pathToAppend(mcpSseBuildConfig.rootPath(), "sse"));
        this.client = new DevUIClient();
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    }

    public JsonArray getToolsData() {
        JsonArray ret = new JsonArray();
        for (ToolManager.ToolInfo tool : this.toolManager) {
            JsonObject toolJson = tool.asJson();
            if (!tool.arguments().isEmpty()) {
                JsonArray args = new JsonArray();
                for (ToolManager.ToolArgument arg : tool.arguments()) {
                    JsonObject argJson = new JsonObject();
                    argJson.put("name", (Object)arg.name());
                    argJson.put("description", (Object)arg.description());
                    argJson.put("required", (Object)arg.required());
                    argJson.put("type", (Object)arg.type().getTypeName());
                    args.add((Object)argJson);
                }
                toolJson.put("args", (Object)args);
            }
            toolJson.put("inputPrototype", (Object)this.createInputPrototype(tool));
            ret.add((Object)toolJson);
        }
        return ret;
    }

    public JsonArray getPromptsData() {
        JsonArray ret = new JsonArray();
        for (PromptManager.PromptInfo prompt : this.promptManager) {
            JsonObject promptJson = prompt.asJson();
            JsonObject inputPrototype = new JsonObject();
            for (PromptManager.PromptArgument arg : prompt.arguments()) {
                inputPrototype.put(arg.name(), (Object)arg.description());
            }
            promptJson.put("inputPrototype", (Object)inputPrototype);
            ret.add((Object)promptJson);
        }
        return ret;
    }

    public JsonArray getPromptCompletionsData() {
        JsonArray ret = new JsonArray();
        for (CompletionManager.CompletionInfo completion : this.promptCompletionManager) {
            JsonObject completionJson = new JsonObject();
            completionJson.put("name", (Object)completion.name());
            completionJson.put("argumentName", (Object)completion.argumentName());
            ret.add((Object)completionJson);
        }
        return ret;
    }

    public JsonArray getResourcesData() {
        JsonArray ret = new JsonArray();
        for (ResourceManager.ResourceInfo resource : this.resourceManager) {
            ret.add((Object)resource.asJson());
        }
        return ret;
    }

    public JsonArray getResourceTemplatesData() {
        JsonArray ret = new JsonArray();
        for (ResourceTemplateManager.ResourceTemplateInfo resourceTemplate : this.resourceTemplateManager) {
            ret.add((Object)resourceTemplate.asJson());
        }
        return ret;
    }

    public JsonArray getResourceTemplateCompletionsData() {
        JsonArray ret = new JsonArray();
        for (CompletionManager.CompletionInfo completion : this.resourceTemplateCompletionManager) {
            JsonObject completionJson = new JsonObject();
            completionJson.put("name", (Object)completion.name());
            completionJson.put("argumentName", (Object)completion.argumentName());
            ret.add((Object)completionJson);
        }
        return ret;
    }

    private JsonObject createInputPrototype(ToolManager.ToolInfo tool) {
        JsonObject inputPrototype = new JsonObject();
        if (!tool.arguments().isEmpty()) {
            for (ToolManager.ToolArgument arg : tool.arguments()) {
                Type type = arg.type();
                if (type instanceof Class) {
                    Class clazz = (Class)type;
                    if (clazz.isPrimitive()) {
                        if (Integer.TYPE.equals(clazz) || Double.TYPE.equals(clazz) || Float.TYPE.equals(clazz) || Byte.TYPE.equals(clazz)) {
                            inputPrototype.put(arg.name(), (Object)42);
                            continue;
                        }
                        if (Boolean.TYPE.equals(clazz)) {
                            inputPrototype.put(arg.name(), (Object)true);
                            continue;
                        }
                        this.unsupportedType(inputPrototype, arg);
                        continue;
                    }
                    if (String.class.equals((Object)arg.type())) {
                        inputPrototype.put(arg.name(), (Object)arg.description());
                        continue;
                    }
                    if (clazz.isAssignableFrom(Number.class)) {
                        inputPrototype.put(arg.name(), (Object)42);
                        continue;
                    }
                    if (Boolean.class.equals((Object)clazz)) {
                        inputPrototype.put(arg.name(), (Object)true);
                        continue;
                    }
                    this.unsupportedType(inputPrototype, arg);
                    continue;
                }
                type = arg.type();
                if (type instanceof ParameterizedType) {
                    Class clazz;
                    ParameterizedType pt = (ParameterizedType)type;
                    Type type2 = pt.getRawType();
                    if (type2 instanceof Class && Collection.class.isAssignableFrom(clazz = (Class)type2)) {
                        inputPrototype.put(arg.name(), List.of());
                        continue;
                    }
                    this.unsupportedType(inputPrototype, arg);
                    continue;
                }
                if (arg.type() instanceof GenericArrayType) {
                    inputPrototype.put(arg.name(), List.of());
                    continue;
                }
                this.unsupportedType(inputPrototype, arg);
            }
        }
        return inputPrototype;
    }

    private void unsupportedType(JsonObject inputPrototype, ToolManager.ToolArgument arg) {
        inputPrototype.put(arg.name(), (Object)(arg.type().getTypeName() + ": " + arg.description()));
    }

    public JsonObject callTool(String name, JsonObject args, String bearerToken, boolean forceNewSession) throws IOException, InterruptedException {
        if (this.toolManager.getTool(name) == null) {
            return new JsonObject().put("error", (Object)("Tool not found: " + name));
        }
        JsonObject message = new JsonObject().put("jsonrpc", (Object)"2.0").put("method", (Object)"tools/call").put("params", (Object)new JsonObject().put("name", (Object)name).put("arguments", (Object)args));
        return this.client.sendRequest(message, bearerToken, forceNewSession);
    }

    public JsonObject getPrompt(String name, JsonObject args, String bearerToken, boolean forceNewSession) throws IOException, InterruptedException {
        if (this.promptManager.getPrompt(name) == null) {
            return new JsonObject().put("error", (Object)("Prompt not found: " + name));
        }
        JsonObject message = new JsonObject().put("jsonrpc", (Object)"2.0").put("method", (Object)"prompts/get").put("params", (Object)new JsonObject().put("name", (Object)name).put("arguments", (Object)args));
        return this.client.sendRequest(message, bearerToken, forceNewSession);
    }

    public JsonObject completePrompt(String name, String argumentName, String argumentValue, String bearerToken, boolean forceNewSession) throws IOException, InterruptedException {
        if (this.promptCompletionManager.getCompletion(name, argumentName) == null) {
            return new JsonObject().put("error", (Object)("Prompt completion not found: " + name));
        }
        JsonObject message = new JsonObject().put("jsonrpc", (Object)"2.0").put("method", (Object)"completion/complete").put("params", (Object)new JsonObject().put("ref", (Object)new JsonObject().put("type", (Object)"ref/prompt").put("name", (Object)name)).put("argument", (Object)new JsonObject().put("name", (Object)argumentName).put("value", (Object)argumentValue)));
        return this.client.sendRequest(message, bearerToken, forceNewSession);
    }

    public JsonObject readResource(String uri, String bearerToken, boolean forceNewSession) throws IOException, InterruptedException {
        if (uri == null || uri.isBlank()) {
            return new JsonObject().put("error", (Object)"Resource uri must be set");
        }
        JsonObject message = new JsonObject().put("jsonrpc", (Object)"2.0").put("method", (Object)"resources/read").put("params", (Object)new JsonObject().put("uri", (Object)uri));
        return this.client.sendRequest(message, bearerToken, forceNewSession);
    }

    public JsonObject completeResourceTemplate(String name, String argumentName, String argumentValue, String bearerToken, boolean forceNewSession) throws IOException, InterruptedException {
        if (this.resourceTemplateCompletionManager.getCompletion(name, argumentName) == null) {
            return new JsonObject().put("error", (Object)("Resource template completion not found: " + name));
        }
        JsonObject message = new JsonObject().put("jsonrpc", (Object)"2.0").put("method", (Object)"completion/complete").put("params", (Object)new JsonObject().put("ref", (Object)new JsonObject().put("type", (Object)"ref/resource").put("name", (Object)name)).put("argument", (Object)new JsonObject().put("name", (Object)argumentName).put("value", (Object)argumentValue)));
        return this.client.sendRequest(message, bearerToken, forceNewSession);
    }

    private String pathToAppend(String prev, String path) {
        if (prev.endsWith("/")) {
            if (path.startsWith("/")) {
                return path.substring(1);
            }
            return path;
        }
        if (path.startsWith("/")) {
            return path;
        }
        return "/" + path;
    }

    class DevUIClient {
        private final Lock lock = new ReentrantLock();
        private final AtomicInteger idGenerator = new AtomicInteger();
        private volatile DevUISseClient sseClient;
        private volatile CompletableFuture<HttpResponse<Void>> sseFuture;
        private final AtomicReference<URI> messageEndpoint = new AtomicReference();

        DevUIClient() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        JsonObject sendRequest(JsonObject message, String bearerToken, boolean forceNewSession) throws InterruptedException, IOException {
            this.lock.lock();
            try {
                JsonObject jsonObject;
                boolean init;
                boolean bl = init = this.sseClient == null || forceNewSession;
                if (init) {
                    if (this.sseFuture != null) {
                        try {
                            this.sseFuture.cancel(true);
                        }
                        catch (Throwable e) {
                            LOG.warnf(e, "Unable to close the SSE connection", new Object[0]);
                        }
                    }
                    this.sseClient = new DevUISseClient(SseMcpJsonRPCService.this.sseEndpoint, me -> this.messageEndpoint.set((URI)me));
                    HashMap<String, CallSite> headers = new HashMap<String, CallSite>();
                    if (bearerToken != null && !bearerToken.isBlank()) {
                        headers.put("Authorization", (CallSite)((Object)("Bearer " + bearerToken)));
                    }
                    this.sseFuture = this.sseClient.connect(SseMcpJsonRPCService.this.httpClient, headers);
                    this.sseClient.awaitEndpoint();
                    Integer initId = this.idGenerator.incrementAndGet();
                    JsonObject initMessage = new JsonObject().put("jsonrpc", (Object)"2.0").put("id", (Object)initId).put("method", (Object)"initialize").put("params", (Object)new JsonObject().put("clientInfo", (Object)new JsonObject().put("name", (Object)"devui-client").put("version", (Object)"1.0")).put("protocolVersion", (Object)"2024-11-05"));
                    HttpRequest request = this.newRequest(bearerToken, initMessage.encode());
                    HttpResponse<Void> response = SseMcpJsonRPCService.this.httpClient.send(request, HttpResponse.BodyHandlers.discarding());
                    if (response.statusCode() != 200) {
                        JsonObject jsonObject2 = new JsonObject().put("error", (Object)("Init failed with invalid HTTP status: " + response.statusCode()));
                        return jsonObject2;
                    }
                    this.sseClient.awaitResponse(initId);
                    JsonObject nofitication = new JsonObject().put("jsonrpc", (Object)"2.0").put("method", (Object)"notifications/initialized");
                    request = this.newRequest(bearerToken, nofitication.encode());
                    response = SseMcpJsonRPCService.this.httpClient.send(request, HttpResponse.BodyHandlers.discarding());
                    if (response.statusCode() != 200) {
                        JsonObject jsonObject3 = new JsonObject().put("error", (Object)("Init notification failed with invalid HTTP status: " + response.statusCode()));
                        return jsonObject3;
                    }
                }
                Integer requestId = this.idGenerator.incrementAndGet();
                message.put("id", (Object)requestId);
                HttpRequest request = this.newRequest(bearerToken, message.encode());
                HttpResponse<Void> response = SseMcpJsonRPCService.this.httpClient.send(request, HttpResponse.BodyHandlers.discarding());
                if (response.statusCode() != 200) {
                    jsonObject = new JsonObject().put("error", (Object)("Invalid HTTP status: " + response.statusCode()));
                    return jsonObject;
                }
                jsonObject = new JsonObject().put("response", (Object)this.sseClient.awaitResponse(requestId));
                return jsonObject;
            }
            finally {
                this.lock.unlock();
            }
        }

        private HttpRequest newRequest(String bearerToken, String body) {
            HttpRequest.Builder builder = HttpRequest.newBuilder().uri(this.messageEndpoint.get()).version(HttpClient.Version.HTTP_1_1).POST(HttpRequest.BodyPublishers.ofString(body));
            if (bearerToken != null && !bearerToken.isBlank()) {
                builder.header("Authorization", "Bearer " + bearerToken);
            }
            return builder.build();
        }
    }

    class DevUISseClient
    extends SseClient {
        private static final int AWAIT_ATTEMPTS = 50;
        private static final int AWAIT_SLEEP = 100;
        private final CountDownLatch endpointLatch;
        private final Consumer<URI> messageEndpointConsumer;
        private final ConcurrentMap<Integer, JsonObject> responses;

        public DevUISseClient(URI sseUri, Consumer<URI> messageEndpointConsumer) {
            super(sseUri);
            this.endpointLatch = new CountDownLatch(1);
            this.responses = new ConcurrentHashMap<Integer, JsonObject>();
            this.messageEndpointConsumer = messageEndpointConsumer;
        }

        void awaitEndpoint() throws InterruptedException {
            if (!this.endpointLatch.await(10L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Endpoint not received");
            }
        }

        JsonObject awaitResponse(Integer id) throws InterruptedException {
            JsonObject response = (JsonObject)this.responses.get(id);
            int attempts = 0;
            while (response == null && attempts++ < 50) {
                TimeUnit.MILLISECONDS.sleep(100L);
                response = (JsonObject)this.responses.remove(id);
            }
            return response;
        }

        protected void process(SseClient.SseEvent event) {
            JsonObject json;
            Integer id;
            if ("endpoint".equals(event.name())) {
                String endpoint = event.data().strip();
                this.messageEndpointConsumer.accept(this.connectUri.resolve(endpoint));
                this.endpointLatch.countDown();
            } else if ("message".equals(event.name()) && (id = (json = new JsonObject(event.data())).getInteger("id")) != null && (json.containsKey("result") || json.containsKey("error"))) {
                this.responses.put(id, json);
            }
        }
    }
}

