/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.sse.runtime;

import io.quarkiverse.mcp.server.McpConnection;
import io.quarkiverse.mcp.server.runtime.McpConnectionBase;
import io.quarkiverse.mcp.server.runtime.config.McpServerRuntimeConfig;
import io.vertx.core.Future;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.logging.Logger;

class StreamableHttpMcpConnection
extends McpConnectionBase {
    private static final Logger LOG = Logger.getLogger(StreamableHttpMcpConnection.class);
    private final List<SubsidiarySse> sseStreams = new CopyOnWriteArrayList<SubsidiarySse>();

    StreamableHttpMcpConnection(String id, McpServerRuntimeConfig serverConfig) {
        super(id, serverConfig);
    }

    void addSse(SubsidiarySse sse) {
        this.sseStreams.add(sse);
    }

    boolean removeSse(String id) {
        return this.sseStreams.removeIf(e -> e.id().equals(id));
    }

    public boolean close() {
        this.sseStreams.clear();
        return super.close();
    }

    public Future<Void> send(JsonObject message) {
        if (message == null) {
            return Future.succeededFuture();
        }
        SubsidiarySse sse = null;
        if (!this.sseStreams.isEmpty()) {
            try {
                sse = this.sseStreams.get(0);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        if (sse == null) {
            String method = message.getString("method");
            LOG.warnf("Discarding message [%s] - no 'subsidiary' SSE streams open yet", (Object)method);
            return Future.succeededFuture();
        }
        if (this.trafficLogger != null) {
            this.trafficLogger.messageSent(message, (McpConnection)this);
        }
        return sse.sendEvent("message", message.encode());
    }

    record SubsidiarySse(String id, HttpServerResponse response) {
        public SubsidiarySse {
            if (id == null) {
                throw new IllegalArgumentException("id must not be null");
            }
            if (response == null) {
                throw new IllegalArgumentException("response must not be null");
            }
        }

        public Future<Void> sendEvent(String name, String data) {
            return this.response.write("event: " + name + "\ndata: " + data + "\n\n");
        }
    }
}

