/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.stdio.runtime;

import io.quarkiverse.mcp.server.McpConnection;
import io.quarkiverse.mcp.server.runtime.ConnectionManager;
import io.quarkiverse.mcp.server.runtime.JsonRPC;
import io.quarkiverse.mcp.server.runtime.McpMessageHandler;
import io.quarkiverse.mcp.server.runtime.PromptCompleteManager;
import io.quarkiverse.mcp.server.runtime.PromptManager;
import io.quarkiverse.mcp.server.runtime.ResourceManager;
import io.quarkiverse.mcp.server.runtime.ResourceTemplateCompleteManager;
import io.quarkiverse.mcp.server.runtime.ResourceTemplateManager;
import io.quarkiverse.mcp.server.runtime.Responder;
import io.quarkiverse.mcp.server.runtime.ToolManager;
import io.quarkiverse.mcp.server.runtime.TrafficLogger;
import io.quarkiverse.mcp.server.runtime.config.McpRuntimeConfig;
import io.quarkiverse.mcp.server.stdio.runtime.StdioMcpConnection;
import io.vertx.core.Vertx;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import jakarta.inject.Singleton;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.logging.Logger;

@Singleton
public class StdioMcpMessageHandler
extends McpMessageHandler {
    private static final Logger LOG = Logger.getLogger(StdioMcpMessageHandler.class);
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final TrafficLogger trafficLogger;
    private final Vertx vertx;

    protected StdioMcpMessageHandler(McpRuntimeConfig config, ConnectionManager connectionManager, PromptManager promptManager, ToolManager toolManager, ResourceManager resourceManager, PromptCompleteManager promptCompleteManager, ResourceTemplateManager resourceTemplateManager, ResourceTemplateCompleteManager resourceTemplateCompleteManager, Vertx vertx) {
        super(config, connectionManager, promptManager, toolManager, resourceManager, promptCompleteManager, resourceTemplateManager, resourceTemplateCompleteManager);
        this.trafficLogger = config.trafficLogging().enabled() ? new TrafficLogger(config.trafficLogging().textLimit()) : null;
        this.vertx = vertx;
    }

    void initialize(PrintStream stdout, McpRuntimeConfig config) {
        String connectionId = Base64.getUrlEncoder().encodeToString(UUID.randomUUID().toString().getBytes());
        final StdioMcpConnection connection = new StdioMcpConnection(connectionId, config.clientLogging().defaultLevel(), this.trafficLogger, config.autoPingInterval(), stdout, this.vertx);
        final InputStream in = System.in;
        this.executor.submit(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        try {
                            JsonObject message;
                            try {
                                message = new JsonObject(line);
                            }
                            catch (Exception e) {
                                String msg = "Unable to parse the JSON message";
                                LOG.errorf((Throwable)e, msg, new Object[0]);
                                connection.sendError(null, -32700, msg);
                                return;
                            }
                            if (StdioMcpMessageHandler.this.trafficLogger != null) {
                                StdioMcpMessageHandler.this.trafficLogger.messageReceived(message);
                            }
                            if (!JsonRPC.validate((JsonObject)message, (Responder)connection)) continue;
                            StdioMcpMessageHandler.this.handle(message, (McpConnection)connection, (Responder)connection);
                        }
                        catch (DecodeException e) {
                            String msg = "Unable to parse the JSON message";
                            LOG.errorf((Throwable)e, msg, new Object[0]);
                        }
                    }
                    return;
                }
                catch (IOException e) {
                    LOG.errorf((Throwable)e, "Error reading stdio", new Object[0]);
                }
            }
        });
    }
}

