/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.stdio.runtime;

import io.quarkiverse.mcp.server.McpLog;
import io.quarkiverse.mcp.server.runtime.McpConnectionBase;
import io.quarkiverse.mcp.server.runtime.TrafficLogger;
import io.quarkus.runtime.BlockingOperationControl;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.io.PrintStream;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.Callable;

public class StdioMcpConnection
extends McpConnectionBase {
    private final PrintStream out;
    private final Vertx vertx;

    StdioMcpConnection(String id, McpLog.LogLevel defaultLogLevel, TrafficLogger trafficLogger, Optional<Duration> autoPingInterval, PrintStream out, Vertx vertx) {
        super(id, defaultLogLevel, trafficLogger, autoPingInterval);
        this.out = out;
        this.vertx = vertx;
    }

    public void send(final JsonObject message) {
        if (message == null) {
            return;
        }
        if (this.trafficLogger != null) {
            this.trafficLogger.messageSent(message);
        }
        if (BlockingOperationControl.isBlockingAllowed()) {
            this.out.println(message.encode());
        } else {
            this.vertx.executeBlocking((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    StdioMcpConnection.this.out.println(message.encode());
                    return null;
                }
            });
        }
    }
}

