/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.stdio.runtime;

import io.quarkiverse.mcp.server.InitialCheck;
import io.quarkiverse.mcp.server.InitialRequest;
import io.quarkiverse.mcp.server.runtime.ConnectionManager;
import io.quarkiverse.mcp.server.runtime.McpConnectionBase;
import io.quarkiverse.mcp.server.runtime.McpMessageHandler;
import io.quarkiverse.mcp.server.runtime.McpMetadata;
import io.quarkiverse.mcp.server.runtime.McpRequest;
import io.quarkiverse.mcp.server.runtime.McpRequestImpl;
import io.quarkiverse.mcp.server.runtime.NotificationManagerImpl;
import io.quarkiverse.mcp.server.runtime.PromptCompletionManagerImpl;
import io.quarkiverse.mcp.server.runtime.PromptManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResourceManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResourceTemplateCompletionManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResourceTemplateManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResponseHandlers;
import io.quarkiverse.mcp.server.runtime.Sender;
import io.quarkiverse.mcp.server.runtime.ToolManagerImpl;
import io.quarkiverse.mcp.server.runtime.config.McpServerRuntimeConfig;
import io.quarkiverse.mcp.server.runtime.config.McpServersRuntimeConfig;
import io.quarkiverse.mcp.server.stdio.runtime.StdioMcpConnection;
import io.quarkus.arc.All;
import io.quarkus.runtime.Quarkus;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.json.Json;
import jakarta.inject.Singleton;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;

@Singleton
public class StdioMcpMessageHandler
extends McpMessageHandler<McpRequestImpl> {
    private static final Logger LOG = Logger.getLogger(StdioMcpMessageHandler.class);
    private final ExecutorService executor;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final McpServerRuntimeConfig serverConfig;

    protected StdioMcpMessageHandler(McpServersRuntimeConfig config, ConnectionManager connectionManager, PromptManagerImpl promptManager, ToolManagerImpl toolManager, ResourceManagerImpl resourceManager, PromptCompletionManagerImpl promptCompleteManager, ResourceTemplateManagerImpl resourceTemplateManager, ResourceTemplateCompletionManagerImpl resourceTemplateCompleteManager, NotificationManagerImpl initManager, ResponseHandlers responseHandlers, @All List<InitialCheck> initialChecks, McpMetadata metadata, Vertx vertx) {
        super(config, connectionManager, promptManager, toolManager, resourceManager, promptCompleteManager, resourceTemplateManager, resourceTemplateCompleteManager, initManager, responseHandlers, metadata, vertx, initialChecks);
        this.executor = Executors.newSingleThreadExecutor();
        if (config.servers().size() > 1) {
            throw new IllegalStateException("Multiple server configurations are not supported for the stdio transport");
        }
        this.serverConfig = (McpServerRuntimeConfig)config.servers().values().iterator().next();
    }

    public void initialize(PrintStream stdout) {
        if (this.initialized.compareAndSet(false, true)) {
            String connectionId = Base64.getUrlEncoder().encodeToString(UUID.randomUUID().toString().getBytes());
            final StdioMcpConnection connection = new StdioMcpConnection(connectionId, this.serverConfig, stdout, this.vertx);
            this.connectionManager.add((McpConnectionBase)connection);
            final InputStream in = System.in;
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                        while (true) {
                            Object json;
                            String line;
                            if ((line = reader.readLine()) == null) {
                                LOG.debug((Object)"EOF received, exiting");
                                Quarkus.asyncExit((int)0);
                                return;
                            }
                            try {
                                json = Json.decodeValue((String)line);
                            }
                            catch (Exception e) {
                                String msg = "Unable to parse the JSON message";
                                LOG.errorf((Throwable)e, msg, new Object[0]);
                                connection.sendError(null, -32700, msg);
                                reader.close();
                                return;
                            }
                            Context context = VertxContext.getOrCreateDuplicatedContext((Vertx)StdioMcpMessageHandler.this.vertx);
                            VertxContextSafetyToggle.setContextSafe((Context)context, (boolean)true);
                            context.executeBlocking((Callable)new Callable<Object>(){

                                @Override
                                public Object call() throws Exception {
                                    McpRequestImpl mcpRequest = new McpRequestImpl("<default>", json, (McpConnectionBase)connection, (Sender)connection, null, null, null);
                                    StdioMcpMessageHandler.this.handle((McpRequest)mcpRequest);
                                    return null;
                                }
                            });
                        }
                    }
                    catch (IOException e) {
                        LOG.errorf((Throwable)e, "Error reading stdio", new Object[0]);
                        return;
                    }
                }
            });
        }
    }

    protected InitialRequest.Transport transport() {
        return InitialRequest.Transport.STDIO;
    }
}

