/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.stdio.runtime;

import io.quarkiverse.mcp.server.stdio.runtime.StdioMcpMessageHandler;
import io.quarkiverse.mcp.server.stdio.runtime.config.McpStdioRuntimeConfig;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.runtime.annotations.Recorder;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import org.jboss.logging.Logger;

@Recorder
public class StdioMcpServerRecorder {
    private static final Logger LOG = Logger.getLogger(StdioMcpServerRecorder.class);
    private final McpStdioRuntimeConfig stdioConfig;

    public StdioMcpServerRecorder(McpStdioRuntimeConfig stdioConfig) {
        this.stdioConfig = stdioConfig;
    }

    public void initialize() {
        if (this.stdioConfig.enabled()) {
            PrintStream stdout = System.out;
            if (this.stdioConfig.nullSystemOut()) {
                System.setOut(new PrintStream(OutputStream.nullOutputStream()));
            }
            ArcContainer container = Arc.container();
            StdioMcpMessageHandler messageHandler = (StdioMcpMessageHandler)((Object)container.instance(StdioMcpMessageHandler.class, new Annotation[0]).get());
            messageHandler.initialize(stdout);
        } else {
            LOG.info((Object)"stdio transport is disabled - application does not read/write MCP messages from/to the standard input/output");
        }
    }
}

