/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.stdio.runtime;

import io.quarkiverse.mcp.server.stdio.runtime.StdioMcpMessageHandler;
import io.quarkiverse.mcp.server.stdio.runtime.config.McpStdioRuntimeConfig;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import org.jboss.logging.Logger;

@Recorder
public class StdioMcpServerRecorder {
    private static final Logger LOG = Logger.getLogger(StdioMcpServerRecorder.class);
    private final RuntimeValue<McpStdioRuntimeConfig> stdioConfig;

    public StdioMcpServerRecorder(RuntimeValue<McpStdioRuntimeConfig> stdioConfig) {
        this.stdioConfig = stdioConfig;
    }

    public void initialize() {
        if (((McpStdioRuntimeConfig)this.stdioConfig.getValue()).enabled()) {
            PrintStream stdout = System.out;
            if (((McpStdioRuntimeConfig)this.stdioConfig.getValue()).nullSystemOut()) {
                System.setOut(new PrintStream(OutputStream.nullOutputStream()));
            }
            ArcContainer container = Arc.container();
            StdioMcpMessageHandler messageHandler = (StdioMcpMessageHandler)((Object)container.instance(StdioMcpMessageHandler.class, new Annotation[0]).get());
            messageHandler.initialize(stdout);
        } else {
            LOG.info((Object)"stdio transport is disabled - application does not read/write MCP messages from/to the standard input/output");
        }
    }
}

