/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.messaginghub.pooled.jms;

import io.quarkiverse.messaginghub.pooled.jms.PooledJmsRuntimeConfig;
import io.quarkiverse.messaginghub.pooled.jms.TransactionIntegration;
import io.quarkiverse.messaginghub.pooled.jms.transaction.LocalTransactionSupport;
import io.quarkiverse.messaginghub.pooled.jms.transaction.XATransactionSupport;
import jakarta.jms.ConnectionFactory;
import java.util.ArrayList;
import java.util.List;
import org.messaginghub.pooled.jms.JmsPoolConnectionFactory;

public class PooledJmsWrapper {
    private boolean transaction;
    private PooledJmsRuntimeConfig pooledJmsRuntimeConfig;
    private static List<JmsPoolConnectionFactory> poolConnectionFactories = new ArrayList<JmsPoolConnectionFactory>();

    public PooledJmsWrapper(boolean transaction, PooledJmsRuntimeConfig pooledJmsRuntimeConfig) {
        this.transaction = transaction;
        this.pooledJmsRuntimeConfig = pooledJmsRuntimeConfig;
    }

    public ConnectionFactory wrapConnectionFactory(ConnectionFactory connectionFactory) {
        if (!this.pooledJmsRuntimeConfig.poolingEnabled()) {
            return connectionFactory;
        }
        if (this.transaction && this.pooledJmsRuntimeConfig.transaction().equals((Object)TransactionIntegration.XA)) {
            if (XATransactionSupport.isEnabled()) {
                JmsPoolConnectionFactory cf = XATransactionSupport.getXAConnectionFactory(connectionFactory, this.pooledJmsRuntimeConfig);
                poolConnectionFactories.add(cf);
                return cf;
            }
            throw new IllegalStateException("XA Transaction support is not available");
        }
        if (this.transaction && this.pooledJmsRuntimeConfig.transaction().equals((Object)TransactionIntegration.ENABLED)) {
            if (LocalTransactionSupport.isEnabled()) {
                JmsPoolConnectionFactory cf = LocalTransactionSupport.getLocalTransactionConnectionFactory(connectionFactory, this.pooledJmsRuntimeConfig);
                poolConnectionFactories.add(cf);
                return cf;
            }
            throw new IllegalStateException("Local TransactionManager support is not available");
        }
        JmsPoolConnectionFactory cf = this.getConnectionFactory(connectionFactory);
        poolConnectionFactories.add(cf);
        return cf;
    }

    public void clearAll() {
        for (JmsPoolConnectionFactory cf : poolConnectionFactories) {
            cf.clear();
        }
    }

    private JmsPoolConnectionFactory getConnectionFactory(ConnectionFactory connectionFactory) {
        JmsPoolConnectionFactory poolConnectionFactory = new JmsPoolConnectionFactory();
        PooledJmsWrapper.pooledJmsRuntimeConfigureConnectionFactory(poolConnectionFactory, connectionFactory, this.pooledJmsRuntimeConfig);
        return poolConnectionFactory;
    }

    public static void pooledJmsRuntimeConfigureConnectionFactory(JmsPoolConnectionFactory poolConnectionFactory, ConnectionFactory connectionFactory, PooledJmsRuntimeConfig pooledJmsRuntimeConfig) {
        poolConnectionFactory.setConnectionFactory((Object)connectionFactory);
        poolConnectionFactory.setMaxConnections(pooledJmsRuntimeConfig.maxConnections());
        poolConnectionFactory.setConnectionIdleTimeout(pooledJmsRuntimeConfig.connectionIdleTimeout());
        poolConnectionFactory.setConnectionCheckInterval(pooledJmsRuntimeConfig.connectionCheckInterval());
        poolConnectionFactory.setUseProviderJMSContext(pooledJmsRuntimeConfig.useProviderJMSContext());
        poolConnectionFactory.setMaxSessionsPerConnection(pooledJmsRuntimeConfig.maxSessionsPerConnection());
        poolConnectionFactory.setBlockIfSessionPoolIsFull(pooledJmsRuntimeConfig.blockIfSessionPoolIsFull());
        poolConnectionFactory.setBlockIfSessionPoolIsFullTimeout((long)pooledJmsRuntimeConfig.blockIfSessionPoolIsFullTimeout());
        poolConnectionFactory.setUseAnonymousProducers(pooledJmsRuntimeConfig.useAnonymousProducers());
    }
}

