/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.messaginghub.pooled.jms;

import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import jakarta.jms.Session;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import org.messaginghub.pooled.jms.JmsPoolSession;
import org.messaginghub.pooled.jms.pool.PooledConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledLocalTransactionConnection
extends PooledConnection {
    private static final Logger LOG = LoggerFactory.getLogger(PooledLocalTransactionConnection.class);
    private final TransactionManager transactionManager;

    public PooledLocalTransactionConnection(Connection connection, TransactionManager transactionManager) {
        super(connection);
        this.transactionManager = transactionManager;
    }

    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        try {
            boolean isTransacted;
            boolean bl = isTransacted = this.transactionManager != null && this.transactionManager.getStatus() != 6;
            if (isTransacted) {
                transacted = true;
                ackMode = 0;
            }
            final JmsPoolSession session = (JmsPoolSession)super.createSession(transacted, ackMode);
            if (isTransacted) {
                session.setIgnoreClose(true);
                this.transactionManager.getTransaction().registerSynchronization(new Synchronization(){

                    public void beforeCompletion() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void afterCompletion(int status) {
                        boolean isCommitted = status == 3;
                        try {
                            if (isCommitted) {
                                session.commit();
                                return;
                            }
                            session.rollback();
                            return;
                        }
                        catch (JMSException e) {
                            LOG.error("Can not {} JMS Session", (Object)(isCommitted ? "commit" : "rollback"), (Object)e);
                            return;
                        }
                        finally {
                            try {
                                session.setIgnoreClose(false);
                                session.close();
                            }
                            catch (JMSException e) {
                                throw new RuntimeException(e);
                            }
                            finally {
                                PooledLocalTransactionConnection.this.decrementReferenceCount();
                            }
                        }
                    }
                });
                this.incrementReferenceCount();
            } else {
                session.setIgnoreClose(false);
            }
            return session;
        }
        catch (RollbackException e) {
            JMSException jmsException = new JMSException("Rollback Exception");
            jmsException.initCause((Throwable)e);
            throw jmsException;
        }
        catch (SystemException e) {
            JMSException jmsException = new JMSException("System Exception");
            jmsException.initCause((Throwable)e);
            throw jmsException;
        }
    }
}

