/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.messaginghub.pooled.jms.transaction;

import io.quarkiverse.messaginghub.pooled.jms.PooledJmsRuntimeConfig;
import io.quarkiverse.messaginghub.pooled.jms.PooledJmsWrapper;
import io.quarkus.arc.Arc;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.XAConnectionFactory;
import jakarta.transaction.TransactionManager;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.narayana.jta.jms.JmsXAResourceRecoveryHelper;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.messaginghub.pooled.jms.JmsPoolConnectionFactory;
import org.messaginghub.pooled.jms.JmsPoolXAConnectionFactory;

public class XATransactionSupportIndirect {
    public static JmsPoolConnectionFactory getXAConnectionFactory(ConnectionFactory connectionFactory, PooledJmsRuntimeConfig pooledJmsRuntimeConfig) {
        TransactionManager transactionManager = (TransactionManager)Arc.container().instance(TransactionManager.class, new Annotation[0]).get();
        JmsPoolXAConnectionFactory xaConnectionFactory = new JmsPoolXAConnectionFactory();
        xaConnectionFactory.setTransactionManager(transactionManager);
        PooledJmsWrapper.pooledJmsRuntimeConfigureConnectionFactory((JmsPoolConnectionFactory)xaConnectionFactory, connectionFactory, pooledJmsRuntimeConfig);
        XAResourceRecoveryRegistry xaResourceRecoveryRegistry = (XAResourceRecoveryRegistry)Arc.container().instance(XAResourceRecoveryRegistry.class, new Annotation[0]).get();
        boolean recoveryEnable = (Boolean)ConfigProvider.getConfig().getValue("quarkus.transaction-manager.enable-recovery", Boolean.class);
        if (xaResourceRecoveryRegistry != null && recoveryEnable) {
            JmsXAResourceRecoveryHelper recoveryHelper = new JmsXAResourceRecoveryHelper((XAConnectionFactory)xaConnectionFactory);
            xaResourceRecoveryRegistry.addXAResourceRecovery(() -> recoveryHelper.getXAResources());
        }
        return xaConnectionFactory;
    }
}

