/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.micrometer.registry.stackdriver.deployment;

import io.quarkiverse.micrometer.registry.stackdriver.ConditionalRegistryProducer;
import io.quarkiverse.micrometer.registry.stackdriver.StackdriverConfig;
import io.quarkiverse.micrometer.registry.stackdriver.StackdriverMeterRegistryProvider;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageConfigBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.micrometer.deployment.MicrometerRegistryProviderBuildItem;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import java.util.function.BooleanSupplier;

public class StackdriverRegistryProcessor {
    public static final String REGISTRY_CLASS_NAME = "io.micrometer.stackdriver.StackdriverMeterRegistry";
    public static final Class<?> REGISTRY_CLASS = MicrometerRecorder.getClassForName((String)"io.micrometer.stackdriver.StackdriverMeterRegistry");

    @BuildStep(onlyIf={StackdriverEnabled.class, NativeBuild.class})
    NativeImageConfigBuildItem nativeImageConfiguration() {
        NativeImageConfigBuildItem.Builder builder = NativeImageConfigBuildItem.builder().addRuntimeReinitializedClass("com.sun.management.internal.PlatformMBeanProviderImpl");
        return builder.build();
    }

    @BuildStep(onlyIf={StackdriverEnabled.class})
    public MicrometerRegistryProviderBuildItem createStackdriverRegistry(CombinedIndexBuildItem index, StackdriverConfig.StackdriverBuildConfig stackdriverBuildConfig, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(StackdriverMeterRegistryProvider.class);
        if (stackdriverBuildConfig.defaultRegistry) {
            builder.addBeanClass(ConditionalRegistryProducer.class);
        }
        additionalBeans.produce((BuildItem)builder.build());
        return new MicrometerRegistryProviderBuildItem(REGISTRY_CLASS);
    }

    public static class StackdriverEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;
        StackdriverConfig.StackdriverBuildConfig stackdriverConfig;

        @Override
        public boolean getAsBoolean() {
            return REGISTRY_CLASS != null && QuarkusClassLoader.isClassPresentAtRuntime((String)StackdriverRegistryProcessor.REGISTRY_CLASS_NAME) && this.mConfig.checkRegistryEnabledWithDefault((MicrometerConfig.CapabilityEnabled)this.stackdriverConfig);
        }
    }
}

