/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.minio.client.deployment;

import io.minio.MinioClient;
import io.quarkiverse.minio.client.EmptyHttpClientProducer;
import io.quarkiverse.minio.client.MinioClients;
import io.quarkiverse.minio.client.MinioQualifier;
import io.quarkiverse.minio.client.MinioRecorder;
import io.quarkiverse.minio.client.MiniosBuildTimeConfiguration;
import io.quarkiverse.minio.client.MiniosRuntimeConfiguration;
import io.quarkiverse.minio.client.WithMetricsHttpClientProducer;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import java.util.Map;
import java.util.function.BooleanSupplier;
import javax.inject.Singleton;

class MinioClientProcessor {
    private static final String FEATURE = "minio-client";

    MinioClientProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep(onlyIfNot={MetricsEnabled.class})
    void ifMetricsAreDisabled(BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer) {
        additionalBeanBuildItemBuildProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(EmptyHttpClientProducer.class));
    }

    @BuildStep(onlyIf={MetricsEnabled.class})
    void ifMetricsAreEnabled(BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer) {
        additionalBeanBuildItemBuildProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(WithMetricsHttpClientProducer.class));
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void produce(MiniosBuildTimeConfiguration miniosBuildTimeConfiguration, MiniosRuntimeConfiguration miniosRuntimeConfiguration, MinioRecorder minioRecorder, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        if (miniosBuildTimeConfiguration.getMinioClients().isEmpty()) {
            return;
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(MinioQualifier.class).build());
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{MinioClients.class}).setUnremovable().setDefaultScope(DotNames.SINGLETON).build());
        for (Map.Entry entry : miniosBuildTimeConfiguration.getMinioClients().entrySet()) {
            String minioClientName = (String)entry.getKey();
            SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(MinioClient.class).scope(Singleton.class)).setRuntimeInit().unremovable()).supplier(minioRecorder.minioClientSupplier(minioClientName, miniosRuntimeConfiguration));
            if (MiniosBuildTimeConfiguration.isDefault((String)minioClientName)) {
                configurator.addQualifier(DotNames.DEFAULT);
            } else {
                configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)minioClientName).done();
                configurator.addQualifier().annotation(MinioQualifier.class).addValue("value", (Object)minioClientName).done();
            }
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)configurator.done());
        }
    }

    public static class MetricsEnabled
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return QuarkusClassLoader.isClassPresentAtRuntime((String)"io.micrometer.core.instrument.MeterRegistry");
        }
    }
}

