/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.minio.client.deployment.devservices;

import io.quarkiverse.minio.client.MiniosBuildTimeConfiguration;
import io.quarkiverse.minio.client.deployment.devservices.MinioBuildTimeConfig;
import io.quarkiverse.minio.client.deployment.devservices.MinioDevServicesBuildTimeConfig;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.devservices.common.ContainerShutdownCloseable;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.io.Closeable;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class DevServicesMinioProcessor {
    private static final Logger LOGGER = Logger.getLogger(DevServicesMinioProcessor.class);
    private static final String MINIO_URL = "quarkus.minio%s.url";
    private static final String MINIO_CONSOLE = "quarkus.minio.console";
    private static final String MINIO_ALLOW_EMPTY = "quarkus.minio%s.allow-empty";
    private static final String MINIO_ACCESS_KEY = "quarkus.minio%s.access-key";
    private static final String MINIO_SECRET_KEY = "quarkus.minio%s.secret-key";
    static final String DEV_SERVICE_LABEL = "quarkus-dev-service-minio";
    static final int MINIO_PORT = 9000;
    static final int MINIO_CONSOLE_PORT = 9001;
    private static final ContainerLocator minioContainerLocator = new ContainerLocator("quarkus-dev-service-minio", 9000);
    static volatile DevServicesResultBuildItem.RunningDevService devService;
    static volatile MinioDevServiceCfg cfg;
    static volatile boolean first;

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
    public DevServicesResultBuildItem startMinioDevService(DockerStatusBuildItem dockerStatusBuildItem, LaunchModeBuildItem launchMode, MinioBuildTimeConfig minioBuildTimeConfig, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig devServicesConfig, MiniosBuildTimeConfiguration buildTimeConfiguration, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem) {
        MinioDevServiceCfg configuration = this.getConfiguration(minioBuildTimeConfig);
        if (devService != null) {
            boolean shouldShutdownTheBroker;
            boolean bl = shouldShutdownTheBroker = !configuration.equals(cfg);
            if (!shouldShutdownTheBroker) {
                return devService.toBuildItem();
            }
            this.shutdownServer();
            cfg = null;
        }
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Minio Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            devService = this.startMinio(dockerStatusBuildItem, configuration, launchMode, devServicesConfig.timeout, buildTimeConfiguration, !devServicesSharedNetworkBuildItem.isEmpty());
            if (devService == null) {
                compressor.closeAndDumpCaptured();
            } else {
                compressor.close();
            }
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
        }
        if (devService == null) {
            return null;
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                if (devService != null) {
                    this.shutdownServer();
                }
                first = true;
                devService = null;
                cfg = null;
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
        cfg = configuration;
        if (devService.isOwner()) {
            LOGGER.infof("Dev Services for Minio started on %s", (Object)DevServicesMinioProcessor.getMinioUrl());
            LOGGER.infof("Other Quarkus applications in dev mode will find the instance automatically. For Quarkus applications in production mode, you can connect to this by starting your application with -D%s=%s -D%s=%s -D%s=%s", new Object[]{DevServicesMinioProcessor.formatPropertyName(MINIO_URL), DevServicesMinioProcessor.getMinioUrl(), DevServicesMinioProcessor.formatPropertyName(MINIO_ACCESS_KEY), DevServicesMinioProcessor.getMinioAccessKey(), DevServicesMinioProcessor.formatPropertyName(MINIO_SECRET_KEY), DevServicesMinioProcessor.getMinioSecretKey()});
        }
        return devService.toBuildItem();
    }

    public static String getMinioUrl() {
        return (String)devService.getConfig().get(DevServicesMinioProcessor.formatPropertyName(MINIO_URL));
    }

    public static String getMinioAccessKey() {
        return (String)devService.getConfig().get(DevServicesMinioProcessor.formatPropertyName(MINIO_ACCESS_KEY));
    }

    public static String getMinioSecretKey() {
        return (String)devService.getConfig().get(DevServicesMinioProcessor.formatPropertyName(MINIO_SECRET_KEY));
    }

    private void shutdownServer() {
        if (devService != null) {
            try {
                devService.close();
            }
            catch (Throwable e) {
                LOGGER.error((Object)"Failed to stop the Minio server", e);
            }
            finally {
                devService = null;
            }
        }
    }

    private DevServicesResultBuildItem.RunningDevService startMinio(DockerStatusBuildItem dockerStatusBuildItem, MinioDevServiceCfg config, LaunchModeBuildItem launchMode, Optional<Duration> timeout, MiniosBuildTimeConfiguration buildTimeConfiguration, boolean useSharedNetwork) {
        if (!config.devServicesEnabled) {
            LOGGER.debug((Object)"Not starting dev services for Minio, as it has been disabled in the config.");
            return null;
        }
        if (ConfigUtils.isPropertyPresent((String)DevServicesMinioProcessor.formatPropertyName(MINIO_URL))) {
            LOGGER.debug((Object)"Not starting dev services for Minio, the quarkus.minio.url is configured.");
            return null;
        }
        Optional allowEmpty = ConfigUtils.getFirstOptionalValue(List.of(DevServicesMinioProcessor.formatPropertyName(MINIO_ALLOW_EMPTY)), Boolean.class);
        if (allowEmpty.isPresent() && ((Boolean)allowEmpty.get()).booleanValue()) {
            LOGGER.debug((Object)"Not starting dev services for Minio, the quarkus.minio.allow-empty is set to true.");
            return null;
        }
        if (!dockerStatusBuildItem.isDockerAvailable()) {
            LOGGER.warn((Object)String.format("Docker isn't working, please configure the Minio Url property (%s).", DevServicesMinioProcessor.formatPropertyName(MINIO_URL)));
            return null;
        }
        Optional maybeContainerAddress = minioContainerLocator.locateContainer(config.serviceName, config.shared, launchMode.getLaunchMode());
        Optional maybeConsolePort = minioContainerLocator.locatePublicPort(config.serviceName, config.shared, launchMode.getLaunchMode(), 9001);
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultMinioBrokerSupplier = () -> {
            MinioContainer container = new MinioContainer(DockerImageName.parse((String)config.imageName), config.fixedExposedPort, config.accessKey, config.secretKey, useSharedNetwork);
            if (config.serviceName != null) {
                container.withLabel(DEV_SERVICE_LABEL, config.serviceName);
            }
            timeout.ifPresent(arg_0 -> ((MinioContainer)container).withStartupTimeout(arg_0));
            container.withReuse(true);
            container.start();
            return new DevServicesResultBuildItem.RunningDevService(config.serviceName, container.getContainerId(), (Closeable)new ContainerShutdownCloseable((GenericContainer)container, config.serviceName), this.getRunningDevServicesConfig(config, container.getEffectiveHost(), container.getPort(), container.getHost(), Optional.of(container.getConsolePort()), buildTimeConfiguration));
        };
        return maybeContainerAddress.map(containerAddress -> new DevServicesResultBuildItem.RunningDevService(config.serviceName, containerAddress.getId(), null, this.getRunningDevServicesConfig(config, containerAddress.getHost(), containerAddress.getPort(), containerAddress.getHost(), maybeConsolePort, buildTimeConfiguration))).orElseGet(defaultMinioBrokerSupplier);
    }

    private Map<String, String> getRunningDevServicesConfig(MinioDevServiceCfg config, String host, int port, String consoleHost, Optional<Integer> maybeConsolePort, MiniosBuildTimeConfiguration buildTimeConfiguration) {
        HashMap<String, String> result = new HashMap<String, String>();
        maybeConsolePort.ifPresent(consolePort -> result.put(MINIO_CONSOLE, String.format("http://%s:%d", consoleHost, consolePort)));
        buildTimeConfiguration.getMinioClients().entrySet().stream().map(entry -> Map.of(DevServicesMinioProcessor.formatPropertyName(MINIO_URL, (String)entry.getKey()), String.format("http://%s:%d", host, port), DevServicesMinioProcessor.formatPropertyName(MINIO_ACCESS_KEY, (String)entry.getKey()), config.accessKey, DevServicesMinioProcessor.formatPropertyName(MINIO_SECRET_KEY, (String)entry.getKey()), config.secretKey)).forEach(result::putAll);
        return result;
    }

    private static String formatPropertyName(String property) {
        return DevServicesMinioProcessor.formatPropertyName(property, null);
    }

    private static String formatPropertyName(String property, String minoClientName) {
        Object key = "";
        if (!MiniosBuildTimeConfiguration.isDefault((String)minoClientName) && minoClientName != null) {
            key = "." + minoClientName;
        }
        return String.format(property, key);
    }

    private MinioDevServiceCfg getConfiguration(MinioBuildTimeConfig cfg) {
        MinioDevServicesBuildTimeConfig devServicesConfig = cfg.devservices;
        return new MinioDevServiceCfg(devServicesConfig);
    }

    static {
        first = true;
    }

    private static final class MinioContainer
    extends GenericContainer<MinioContainer> {
        private final int port;
        private final boolean useSharedNetwork;
        private String hostName = null;

        private MinioContainer(DockerImageName dockerImageName, int fixedExposedPort, String accessKey, String secretKey, boolean useSharedNetwork) {
            super(dockerImageName);
            this.port = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
            this.withExposedPorts(new Integer[]{9000, 9001});
            this.withEnv("MINIO_ACCESS_KEY", accessKey);
            this.withEnv("MINIO_SECRET_KEY", secretKey);
            this.withCommand(new String[]{"server", "/data", "--console-address", ":9001"});
            this.waitingFor((WaitStrategy)new HttpWaitStrategy().forPort(9000).forPath("/minio/health/live"));
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"minio");
            } else {
                this.withNetwork(Network.SHARED);
            }
            if (this.port > 0) {
                this.addFixedExposedPort(this.port, 9000);
            }
        }

        public String getEffectiveHost() {
            if (this.useSharedNetwork) {
                return this.hostName;
            }
            return this.getHost();
        }

        public int getPort() {
            if (this.useSharedNetwork) {
                return 9000;
            }
            return this.getMappedPort(9000);
        }

        public int getConsolePort() {
            return this.getMappedPort(9001);
        }
    }

    private static final class MinioDevServiceCfg {
        private final boolean devServicesEnabled;
        private final String imageName;
        private final Integer fixedExposedPort;
        private final boolean shared;
        private final String serviceName;
        private final String accessKey;
        private final String secretKey;

        public MinioDevServiceCfg(MinioDevServicesBuildTimeConfig config) {
            this.devServicesEnabled = config.enabled.orElse(true);
            this.imageName = config.imageName;
            this.fixedExposedPort = config.port.orElse(0);
            this.shared = config.shared;
            this.serviceName = config.serviceName;
            this.accessKey = config.accessKey;
            this.secretKey = config.secretKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MinioDevServiceCfg that = (MinioDevServiceCfg)o;
            return this.devServicesEnabled == that.devServicesEnabled && Objects.equals(this.imageName, that.imageName) && Objects.equals(this.fixedExposedPort, that.fixedExposedPort);
        }

        public int hashCode() {
            return Objects.hash(this.devServicesEnabled, this.imageName, this.fixedExposedPort);
        }
    }
}

