/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.minio.client.deployment;

import io.minio.MinioAsyncClient;
import io.minio.MinioClient;
import io.quarkiverse.minio.client.EmptyHttpClientProducer;
import io.quarkiverse.minio.client.MinioClients;
import io.quarkiverse.minio.client.MinioQualifier;
import io.quarkiverse.minio.client.MinioRecorder;
import io.quarkiverse.minio.client.MiniosBuildTimeConfiguration;
import io.quarkiverse.minio.client.MiniosRuntimeConfiguration;
import io.quarkiverse.minio.client.WithMetricsHttpClientProducer;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

class MinioClientProcessor {
    private static final String FEATURE = "minio-client";

    MinioClientProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void produce(MiniosBuildTimeConfiguration miniosBuildTimeConfiguration, MiniosRuntimeConfiguration miniosRuntimeConfiguration, MinioRecorder minioRecorder, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, BuildProducer<AdditionalBeanBuildItem> additionalBeans, Optional<MetricsCapabilityBuildItem> metricsCapability) {
        if (miniosBuildTimeConfiguration.getMinioClients().isEmpty()) {
            return;
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(MinioQualifier.class).build());
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{MinioClients.class}).setUnremovable().setDefaultScope(DotNames.SINGLETON).build());
        for (Map.Entry entry : miniosBuildTimeConfiguration.getMinioClients().entrySet()) {
            String minioClientName = (String)entry.getKey();
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)MinioClientProcessor.createMinioBeanBuildItem(minioClientName, MinioClient.class, minioRecorder.minioClientSupplier(minioClientName, miniosRuntimeConfiguration)));
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)MinioClientProcessor.createMinioBeanBuildItem(minioClientName, MinioAsyncClient.class, minioRecorder.minioAsyncClientSupplier(minioClientName, miniosRuntimeConfiguration)));
        }
        if (metricsCapability.map(m -> m.metricsSupported("micrometer")).orElse(false).booleanValue()) {
            additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(WithMetricsHttpClientProducer.class));
        } else {
            additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(EmptyHttpClientProducer.class));
        }
    }

    private static <T> SyntheticBeanBuildItem createMinioBeanBuildItem(String minioClientName, Class<T> clientClass, Supplier<T> clientSupplier) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(clientClass).scope(Singleton.class)).setRuntimeInit().supplier(clientSupplier);
        if (MiniosBuildTimeConfiguration.isDefault((String)minioClientName)) {
            configurator.addQualifier(DotNames.DEFAULT);
        } else {
            configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)minioClientName).done();
            configurator.addQualifier().annotation(MinioQualifier.class).addValue("value", (Object)minioClientName).done();
        }
        return configurator.done();
    }
}

