/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.minio.client.deployment;

import io.minio.BaseArgs;
import io.minio.UploadSnowballObjectsArgs;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

class MinioNativeProcessor {
    private static final String FEATURE = "minio-client-native";

    MinioNativeProcessor() {
    }

    @BuildStep
    public void build(BuildProducer<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport) {
        extensionSslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(FEATURE));
    }

    @BuildStep
    void addDependencies(BuildProducer<IndexDependencyBuildItem> indexDependency) {
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("io.minio", "minio"));
    }

    @BuildStep
    RuntimeInitializedClassBuildItem randomConfiguration() {
        return new RuntimeInitializedClassBuildItem(UploadSnowballObjectsArgs.class.getCanonicalName());
    }

    @BuildStep
    void registerForReflection(CombinedIndexBuildItem index, BuildProducer<ReflectiveClassBuildItem> reflectionClasses) {
        List<String> classes = this.getClasses("io.minio.messages", null);
        classes.addAll(this.getClasses("org.simpleframework.xml.core", ".*Label$"));
        classes.addAll(index.getIndex().getAllKnownSubclasses(DotName.createSimple((String)BaseArgs.class.getName())).stream().map(ClassInfo::name).map(DotName::toString).collect(Collectors.toList()));
        reflectionClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])classes.toArray(new String[0])).fields(true).methods(true).build());
    }

    private List<String> getClasses(String packageName, String regexp) {
        List<String> list;
        block9: {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            assert (classLoader != null);
            String path = packageName.replace('.', '/');
            URI uri = Objects.requireNonNull(classLoader.getResource(path)).toURI();
            FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
            try {
                Path packagePath = fileSystem.getPath(path, new String[0]);
                List dirs = Files.walk(packagePath, 1, new FileVisitOption[0]).collect(Collectors.toList());
                list = dirs.stream().map(item -> this.findClasses((Path)item, packageName, regexp)).filter(Objects::nonNull).collect(Collectors.toList());
                if (fileSystem == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fileSystem != null) {
                        try {
                            fileSystem.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | URISyntaxException e) {
                    throw new IllegalStateException(e);
                }
            }
            fileSystem.close();
        }
        return list;
    }

    private String findClasses(Path path, String packageName, String regexp) {
        String fileName = path.getFileName().toString();
        if (fileName.endsWith(".class")) {
            String className = fileName.substring(0, fileName.length() - 6);
            if (regexp == null || className.matches(regexp)) {
                return packageName + "." + className;
            }
        }
        return null;
    }
}

