/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.minio.client.deployment;

import io.minio.BaseArgs;
import io.minio.UploadSnowballObjectsArgs;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import java.util.ArrayList;
import java.util.List;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

class MinioNativeProcessor {
    private static final String FEATURE = "minio-client-native";

    MinioNativeProcessor() {
    }

    @BuildStep
    public void build(BuildProducer<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport) {
        extensionSslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(FEATURE));
    }

    @BuildStep
    void addDependencies(BuildProducer<IndexDependencyBuildItem> indexDependency) {
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("io.minio", "minio"));
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("com.carrotsearch.thirdparty", "simple-xml-safe"));
    }

    @BuildStep
    RuntimeInitializedClassBuildItem randomConfiguration() {
        return new RuntimeInitializedClassBuildItem(UploadSnowballObjectsArgs.class.getCanonicalName());
    }

    @BuildStep
    void registerForReflection(CombinedIndexBuildItem index, BuildProducer<ReflectiveClassBuildItem> reflectionClasses) {
        ArrayList<String> classes = new ArrayList<String>();
        classes.addAll(this.getClasses(index, "io.minio.messages"));
        classes.addAll(this.getClasses(index, "org.simpleframework.xml.core", ".*Label$|.*Parameter$"));
        classes.addAll(index.getIndex().getAllKnownSubclasses(DotName.createSimple((String)BaseArgs.class.getName())).stream().map(ClassInfo::name).map(DotName::toString).toList());
        reflectionClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])classes.toArray(new String[0])).constructors(true).fields(true).methods(true).build());
    }

    private List<String> getClasses(CombinedIndexBuildItem index, String packageName) {
        return this.getClasses(index, packageName, ".*");
    }

    private List<String> getClasses(CombinedIndexBuildItem index, String packageName, String regexp) {
        return index.getIndex().getClassesInPackage(packageName).stream().filter(c -> c.name().toString().matches(regexp)).map(c -> c.name().toString()).toList();
    }
}

