/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.minio.client;

import io.minio.MinioClient;
import io.quarkiverse.minio.client.MinioRuntimeConfiguration;
import io.quarkiverse.minio.client.MiniosBuildTimeConfiguration;
import io.quarkiverse.minio.client.MiniosRuntimeConfiguration;
import io.quarkiverse.minio.client.OptionalHttpClientProducer;
import io.quarkus.arc.Arc;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import javax.inject.Singleton;

@Singleton
public class MinioClients {
    private final MiniosBuildTimeConfiguration miniosBuildTimeConfiguration;
    private final MiniosRuntimeConfiguration miniosRuntimeConfiguration;
    private final ConcurrentMap<String, MinioClient> minioClients = new ConcurrentHashMap<String, MinioClient>();
    private final OptionalHttpClientProducer httpClientProducer;
    private static final Predicate<String> IS_NOT_VALID_MINIO_URL = value -> !value.startsWith("http://") && !value.startsWith("https://");

    public MinioClients(MiniosBuildTimeConfiguration miniosBuildTimeConfiguration, MiniosRuntimeConfiguration miniosRuntimeConfiguration, OptionalHttpClientProducer httpClientProducer) {
        this.miniosBuildTimeConfiguration = miniosBuildTimeConfiguration;
        this.miniosRuntimeConfiguration = miniosRuntimeConfiguration;
        this.httpClientProducer = httpClientProducer;
    }

    public static MinioClient fromName(String minioClientName) {
        return ((MinioClients)Arc.container().instance(MinioClients.class, new Annotation[0]).get()).getMinioClient(minioClientName);
    }

    public MinioClient getMinioClient(String minioClientName) {
        return this.minioClients.computeIfAbsent(minioClientName, this::createMinioClient);
    }

    public MinioClient createMinioClient(String minioClientName) {
        if (!this.miniosBuildTimeConfiguration.getMinioClients().containsKey(minioClientName)) {
            throw new IllegalArgumentException("No Minioclient named '" + minioClientName + "' exists");
        }
        MinioRuntimeConfiguration configuration = this.getConfiguration(minioClientName);
        if (IS_NOT_VALID_MINIO_URL.test(configuration.getUrl())) {
            Object errorMessage = MiniosBuildTimeConfiguration.isDefault(minioClientName) ? "\"quarkus.minio.url\" is mandatory and must be a valid url" : "\"quarkus.minio." + minioClientName + ".url\" is mandatory and must be a valid url";
            throw new ConfigurationException((String)errorMessage);
        }
        MinioClient.Builder builder = MinioClient.builder().endpoint(configuration.getUrl()).credentials(configuration.getAccessKey(), configuration.getSecretKey());
        configuration.region.ifPresent(arg_0 -> ((MinioClient.Builder)builder).region(arg_0));
        if (this.miniosRuntimeConfiguration.produceMetrics()) {
            ((Optional)this.httpClientProducer.apply(minioClientName)).ifPresent(arg_0 -> ((MinioClient.Builder)builder).httpClient(arg_0));
        }
        return builder.build();
    }

    private MinioRuntimeConfiguration getConfiguration(String minioClientName) {
        if (MiniosBuildTimeConfiguration.isDefault(minioClientName)) {
            return this.miniosRuntimeConfiguration.minio();
        }
        return this.miniosRuntimeConfiguration.namedMinioClients().getOrDefault(minioClientName, new MinioRuntimeConfiguration());
    }
}

