/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.minio.client;

import io.quarkiverse.minio.client.MinioBuildTimeConfiguration;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

@ConfigRoot(name="minio", phase=ConfigPhase.BUILD_AND_RUN_TIME_FIXED)
public class MiniosBuildTimeConfiguration {
    public static final String DEFAULT_MINIOCLIENT_NAME = "<default>";
    @ConfigItem(name="<<parent>>")
    public MinioBuildTimeConfiguration minio;
    @ConfigItem(name="<<parent>>")
    public Map<String, MinioBuildTimeConfiguration> namedMinioClients;

    public Map<String, MinioBuildTimeConfiguration> getMinioClients() {
        HashMap<String, MinioBuildTimeConfiguration> minioClients = new HashMap<String, MinioBuildTimeConfiguration>();
        if (this.minio == null) {
            this.minio = new MinioBuildTimeConfiguration();
        }
        if (this.minio.enabled) {
            minioClients.put(DEFAULT_MINIOCLIENT_NAME, this.minio);
        }
        minioClients.putAll(this.namedMinioClients.entrySet().stream().filter(entry -> ((MinioBuildTimeConfiguration)entry.getValue()).enabled).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        return minioClients;
    }

    public static boolean isDefault(String minioClientName) {
        return DEFAULT_MINIOCLIENT_NAME.equals(minioClientName);
    }
}

