/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.minio.client;

import io.minio.MinioClient;
import io.quarkiverse.minio.client.MinioConfiguration;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.util.function.Predicate;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class MinioProducer {
    @Inject
    MinioConfiguration configuration;
    private static final Predicate<String> IS_NOT_VALID_MINIO_URL = value -> !value.startsWith("http://") && !value.startsWith("https://");

    @Produces
    @Dependent
    public MinioClient produceMinioClient() {
        if (this.configuration.returnEmptyClient()) {
            return null;
        }
        this.verifyUrl();
        MinioClient.Builder builder = MinioClient.builder().endpoint(this.configuration.getUrl()).credentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
        this.configuration.region.ifPresent(arg_0 -> ((MinioClient.Builder)builder).region(arg_0));
        return builder.build();
    }

    private void verifyUrl() {
        if (IS_NOT_VALID_MINIO_URL.test(this.configuration.getUrl())) {
            throw new ConfigurationException("\"quarkus.minio.url\" is mandatory and must be a valid url");
        }
    }
}

