/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.minio.client;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.Converters;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import java.io.Serializable;
import java.util.Optional;
import org.eclipse.microprofile.config.spi.Converter;

@ConfigMapping(prefix="quarkus.minio")
@ConfigGroup
public interface MinioRuntimeConfiguration {
    @WithConverter(value=EmptyConverter.class)
    public String url();

    @WithConverter(value=EmptyConverter.class)
    public String accessKey();

    @WithConverter(value=EmptyConverter.class)
    public String secretKey();

    public Optional<String> region();

    public Optional<Integer> port();

    @WithDefault(value="true")
    public boolean secure();

    public static class EmptyConverter
    implements Converter<String> {
        Converter<String> delegate = Converters.newEmptyValueConverter((Converter & Serializable)value -> value, (Object)"");

        public String convert(String s) throws IllegalArgumentException, NullPointerException {
            return (String)this.delegate.convert(s);
        }
    }
}

