/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.minio.client;

import io.minio.MinioAsyncClient;
import io.minio.MinioClient;
import io.minio.http.HttpUtils;
import io.quarkiverse.minio.client.MinioRuntimeConfiguration;
import io.quarkiverse.minio.client.MiniosBuildTimeConfiguration;
import io.quarkiverse.minio.client.MiniosConfiguration;
import io.quarkiverse.minio.client.OptionalHttpClientProducer;
import io.quarkus.arc.Arc;
import io.quarkus.runtime.configuration.ConfigurationException;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;

@Singleton
public class MinioClients {
    private final MiniosBuildTimeConfiguration miniosBuildTimeConfiguration;
    private final MiniosConfiguration miniosConfiguration;
    private final ConcurrentMap<String, MinioClient> minioClients = new ConcurrentHashMap<String, MinioClient>();
    private final ConcurrentMap<String, MinioAsyncClient> minioAsyncClients = new ConcurrentHashMap<String, MinioAsyncClient>();
    private final OptionalHttpClientProducer httpClientProducer;
    private static final Predicate<String> IS_HOST_SET = value -> value == null || value.isBlank();

    public MinioClients(MiniosBuildTimeConfiguration miniosBuildTimeConfiguration, MiniosConfiguration miniosConfiguration, OptionalHttpClientProducer httpClientProducer) {
        this.miniosBuildTimeConfiguration = miniosBuildTimeConfiguration;
        this.miniosConfiguration = miniosConfiguration;
        this.httpClientProducer = httpClientProducer;
    }

    public static MinioClient fromName(String minioClientName) {
        return ((MinioClients)Arc.container().instance(MinioClients.class, new Annotation[0]).get()).getMinioClient(minioClientName);
    }

    public static MinioAsyncClient fromNameAsync(String minioClientName) {
        return ((MinioClients)Arc.container().instance(MinioClients.class, new Annotation[0]).get()).getMinioAsyncClient(minioClientName);
    }

    public MinioClient getMinioClient(String minioClientName) {
        return this.minioClients.computeIfAbsent(minioClientName, this::createMinioClient);
    }

    public MinioAsyncClient getMinioAsyncClient(String minioClientName) {
        return this.minioAsyncClients.computeIfAbsent(minioClientName, this::createMinioAsyncClient);
    }

    public MinioClient createMinioClient(String minioClientName) {
        MinioRuntimeConfiguration configuration = this.getAndVerifyConfiguration(minioClientName);
        MinioClient.Builder builder = MinioClient.builder();
        configuration.port().ifPresentOrElse(port -> builder.endpoint(configuration.host(), port.intValue(), configuration.secure()), () -> builder.endpoint(HttpUtils.getBaseUrl((String)configuration.host()).newBuilder().scheme(configuration.secure() ? "https" : "http").build()));
        builder.credentials(configuration.accessKey(), configuration.secretKey());
        configuration.region().ifPresent(arg_0 -> ((MinioClient.Builder)builder).region(arg_0));
        if (this.miniosConfiguration.produceMetrics()) {
            ((Optional)this.httpClientProducer.apply(minioClientName)).ifPresent(arg_0 -> ((MinioClient.Builder)builder).httpClient(arg_0));
        }
        return builder.build();
    }

    public MinioAsyncClient createMinioAsyncClient(String minioClientName) {
        MinioRuntimeConfiguration configuration = this.getAndVerifyConfiguration(minioClientName);
        MinioAsyncClient.Builder builder = MinioAsyncClient.builder();
        configuration.port().ifPresentOrElse(port -> builder.endpoint(configuration.host(), port.intValue(), configuration.secure()), () -> builder.endpoint(HttpUtils.getBaseUrl((String)configuration.host()).newBuilder().scheme(configuration.secure() ? "https" : "http").build()));
        builder.credentials(configuration.accessKey(), configuration.secretKey());
        configuration.region().ifPresent(arg_0 -> ((MinioAsyncClient.Builder)builder).region(arg_0));
        if (this.miniosConfiguration.produceMetrics()) {
            ((Optional)this.httpClientProducer.apply(minioClientName)).ifPresent(arg_0 -> ((MinioAsyncClient.Builder)builder).httpClient(arg_0));
        }
        return builder.build();
    }

    private MinioRuntimeConfiguration getAndVerifyConfiguration(String minioClientName) {
        if (!this.miniosBuildTimeConfiguration.getMinioClients().containsKey(minioClientName)) {
            throw new IllegalArgumentException("No Minioclient named '" + minioClientName + "' exists");
        }
        MinioRuntimeConfiguration configuration = MiniosBuildTimeConfiguration.isDefault(minioClientName) ? this.miniosConfiguration.minio().get() : this.miniosConfiguration.namedMinioClients().get(minioClientName);
        if (configuration == null || IS_HOST_SET.test(configuration.host())) {
            Object errorMessage = MiniosBuildTimeConfiguration.isDefault(minioClientName) ? "\"quarkus.minio.host\" is mandatory." : "\"quarkus.minio." + minioClientName + ".host\" is mandatory.";
            throw new ConfigurationException((String)errorMessage);
        }
        return configuration;
    }
}

