/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.minio.client;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.okhttp3.OkHttpMetricsEventListener;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.internal.OnlyOnceLoggingDenyMeterFilter;
import io.quarkiverse.minio.client.MiniosBuildTimeConfiguration;
import io.quarkiverse.minio.client.MiniosConfiguration;
import io.quarkiverse.minio.client.OptionalHttpClientProducer;
import jakarta.inject.Singleton;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.EventListener;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;

@Singleton
public class WithMetricsHttpClientProducer
implements OptionalHttpClientProducer {
    protected static final long DEFAULT_CONNECTION_TIMEOUT = 5L;
    private MeterRegistry meterRegistry;
    private MiniosConfiguration configuration;

    public WithMetricsHttpClientProducer(MeterRegistry meterRegistry, MiniosConfiguration configuration) {
        this.meterRegistry = meterRegistry;
        this.configuration = configuration;
    }

    @Override
    public Optional<OkHttpClient> apply(String minioClientName) {
        if (!this.configuration.produceMetrics()) {
            return Optional.empty();
        }
        return Optional.of(this.getHttpClientWithInterceptor(this.meterRegistry, minioClientName));
    }

    private OkHttpClient getHttpClientWithInterceptor(MeterRegistry meterRegistry, String minioClientName) {
        Object metricKey = MiniosBuildTimeConfiguration.isDefault(minioClientName) ? "minio.client" : "minio." + minioClientName + ".client";
        meterRegistry.config().meterFilter(this.maximumAllowedTag((String)metricKey));
        OkHttpClient httpClient = new OkHttpClient().newBuilder().connectTimeout(5L, TimeUnit.MINUTES).writeTimeout(5L, TimeUnit.MINUTES).readTimeout(5L, TimeUnit.MINUTES).protocols(List.of(Protocol.HTTP_1_1)).eventListener((EventListener)OkHttpMetricsEventListener.builder((MeterRegistry)meterRegistry, (String)metricKey).uriMapper(request -> String.join((CharSequence)"/", request.url().pathSegments())).build()).build();
        String filename = System.getenv("SSL_CERT_FILE");
        if (filename != null && !filename.isEmpty()) {
            try {
                httpClient = this.enableExternalCertificates(httpClient, filename);
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
        return httpClient;
    }

    private MeterFilter maximumAllowedTag(String metricName) {
        OnlyOnceLoggingDenyMeterFilter denyFilter = new OnlyOnceLoggingDenyMeterFilter(() -> String.format("Reached the maximum number (%s) of URI tags for '%s'. Are you using path parameters?", this.configuration.maximumAllowedTag(), metricName));
        return MeterFilter.maximumAllowableTags((String)metricName, (String)"uri", (int)this.configuration.maximumAllowedTag(), (MeterFilter)denyFilter);
    }

    private OkHttpClient enableExternalCertificates(OkHttpClient httpClient, String filename) throws GeneralSecurityException, IOException {
        Collection<? extends Certificate> certificates = null;
        try (FileInputStream fis = new FileInputStream(filename);){
            certificates = CertificateFactory.getInstance("X.509").generateCertificates(fis);
        }
        if (certificates == null || certificates.isEmpty()) {
            throw new IllegalArgumentException("expected non-empty set of trusted certificates");
        }
        char[] password = "password".toCharArray();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, password);
        int index = 0;
        for (Certificate certificate : certificates) {
            String certificateAlias = Integer.toString(index++);
            keyStore.setCertificateEntry(certificateAlias, certificate);
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, password);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagers, null);
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        return httpClient.newBuilder().sslSocketFactory(sslSocketFactory, (X509TrustManager)trustManagers[0]).build();
    }
}

